#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
static bool FloodConditionFun(
       CapyImg const* const img,
  CapyImgPixel const* const from,
  CapyImgPixel const* const to) {
  return (
    fabs(
      img->pixels[from->idx].intensity - img->pixels[to->idx].intensity) < 0.5);
}

#endif
CUTEST(test001, "segmentImg, updateApproxQuadrilateral") {
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestFloodFill/test007.png", "rb");
  CapyImg* img = $(&png, loadImg)(&stream);
  CapyFloodFill* flood = CapyFloodFillAlloc();
  CapyColorPatches* segments =
    $(flood, segmentImg)(img, img, FloodConditionFun);
  size_t nbSegments = $(segments, getNbPatch)();
  CUTEST_ASSERT(nbSegments == 8, "unexpected nbSegments %lu", nbSegments);
  forEach(segment, segments->list->iter) {
    size_t size = $(&(segment.pixels), getSize)();
    CUTEST_ASSERT(size > 0, "segmentImg failed");
    $(&(segment.pixels), initIterator)();
    forEach(pixel, segment.pixels.iter) loop(k, 3) {
      img->pixels[pixel.idx].rgb[k] = (double)segment.idx / (double)nbSegments;
    }
  }
  $(&stream, open)("UnitTests/TestFloodFill/test007_segmented.png", "rb");
  CapyImg* check = $(&png, loadImg)(&stream);
  forEach(pixel, check->iter) {
    loop(i, 4) {
      CUTEST_ASSERT(
        fabs(
          check->pixels[pixel.idx].RGBA[i] -
          img->pixels[pixel.idx].RGBA[i]) < 1.0 / 255.0,
        "segmentImg failed [%d,%d,%d]=%lf != %lf",
        pixel.pos.x, pixel.pos.y, i,
        check->pixels[pixel.idx].RGBA[i], img->pixels[pixel.idx].RGBA[i]);
    }
  }
  int checkB[] = {
    0, 0, 15, 0, 15, 15, 0, 15,
    4, 4, 6, 4, 6, 6, 4, 6,
    9, 4, 11, 4, 11, 6, 9, 6,
    5, 5, 5, 5, 5, 5, 5, 5,
    10, 5, 10, 5, 10, 5, 10, 5,
    7, 8, 7, 8, 8, 10, 7, 10,
    3, 10, 3, 10, 3, 10, 3, 11,
    4, 12, 12, 10, 12, 10, 12, 12,
  };
  int iCheck = 0;
  forEach(segment, segments->list->iter) {
    $(segmentPtr, updateApproxQuadrilateral)();
    loop(i, 4) {
      CUTEST_ASSERT(
        (int)(segmentPtr->approxQuad.corners[i].x) ==
          checkB[iCheck * 8 + i * 2],
        "updateApproxQuadrilateral failed [%lu,%d]=%d != %d",
        segments->list->iter.idx, i,
        (int)(segmentPtr->approxQuad.corners[i].x),
        checkB[iCheck * 8 + i * 2]);
      CUTEST_ASSERT(
        (int)(segmentPtr->approxQuad.corners[i].y) ==
          checkB[iCheck * 8 + i * 2 + 1],
        "updateApproxQuadrilateral failed [%lu,%d]=%d != %d",
        segments->list->iter.idx, i,
        (int)(segmentPtr->approxQuad.corners[i].y),
        checkB[iCheck * 8 + i * 2 + 1]);
    }
    iCheck++;
  }
  $(&stream, destruct)();
  $(&png, destruct)();
  CapyImgFree(&check);
  CapyColorPatchesFree(&segments);
  CapyFloodFillFree(&flood);
  CapyImgFree(&img);
}
