#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Render ascii table") {
  CapyFont* font = CapyFontAlloc();
  font->scale.vals[0] = 10.0;
  font->scale.vals[1] = 20.0;
  font->forward.vals[0] = 1.5;
  font->forward.vals[1] = 0.0;
  font->spacing.vals[0] = 1.5;
  font->spacing.vals[1] = 1.5;
  char const* text =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZ\n"
    "abcdefghijklmnopqrstuvwxyz\n"
    "0123456789!\"'#$%&()=~`{}*\n"
    "+<>?.,/\\[]-|_;:@^";
  CapyImgDims dims = {.width = 390, .height = 120};
  CapyImg* img = CapyImgAlloc(capyImgMode_rgb, dims);
  CapyPen pen = CapyPenCreate();
  double pos[2] = {0.0, 0.0};
  $(&pen, drawText)(pos, text, font, img);
  $(img, saveToPath)("UnitTests/TestFont/test001.png");
  CapyImg* imgCheck =
    CapyImgLoadFromPath("UnitTests/TestFont/checkTest001.png");
  CUTEST_ASSERT($(img, isSame)(imgCheck), "text rendering failed");
  CapyFontFree(&font);
  CapyImgFree(&img);
  CapyImgFree(&imgCheck);
  $(&pen, destruct)();
}

CUTEST(test002, "Rotated text") {
  CapyFont* font = CapyFontAlloc();
  font->scale.vals[0] = 10.0;
  font->scale.vals[1] = 20.0;
  font->forward.vals[0] = sqrt(2);
  font->forward.vals[1] = sqrt(2);
  char const* text = "ab\ncd";
  CapyImgDims dims = {.width = 100, .height = 100};
  CapyImg* img = CapyImgAlloc(capyImgMode_rgb, dims);
  CapyPen pen = CapyPenCreate();
  double pos[2] = {50.0, 25.0};
  $(&pen, drawText)(pos, text, font, img);
  $(img, saveToPath)("UnitTests/TestFont/test002.png");
  CapyImg* imgCheck =
    CapyImgLoadFromPath("UnitTests/TestFont/checkTest002.png");
  CUTEST_ASSERT($(img, isSame)(imgCheck), "text rendering failed");
  CapyFontFree(&font);
  CapyImgFree(&img);
  CapyImgFree(&imgCheck);
  $(&pen, destruct)();
}
