#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
static bool IsEvtInMostProbableFair(
  CapyDistEvt const* const evt,
              double const threshold) {
  CapyDistDiscrete* that = (CapyDistDiscrete*)capyThat;
  double totalProb = 0.0;
  forEach(occ, that->occ->iter) totalProb += occ.prob;
  double sumProb = 0.0;
  forEach(occ, that->occ->iter) {
    if(occ.evt.ptr == evt->ptr && occ.evt.id == evt->id) {
      $(&(that->occ->iter), toLast)();
    } else {
      sumProb += occ.prob;
    }
  }
  return (sumProb < threshold * totalProb);
}

static bool IsEvtInMostProbableCheat(
  CapyDistEvt const* const evt,
              double const threshold) {
  CapyDistDiscrete* that = (CapyDistDiscrete*)capyThat;
  double totalProb = 0.0;
  forEach(occ, that->occ->iter) totalProb += occ.prob;
  double sumProb = 0.0;
  forEach(occ, that->occ->iter) {
    sumProb += occ.prob;
    if(occ.evt.ptr == evt->ptr && occ.evt.id == evt->id) {
      $(&(that->occ->iter), toLast)();
    }
  }
  return ((totalProb - sumProb) < threshold * totalProb);
}

#endif
CUTEST(test001, "FHT operations") {
  CapyRandom rnd = CapyRandomCreate(0);
  CapyDistDiscrete fairCoin = CapyDistDiscreteCreate(2);
  CapyDistDiscrete cheatCoin = CapyDistDiscreteCreate(2);
  CapyDistDiscreteOccurence fairCoinOcc[2] = {
    {.prob = 0.5, .evt = {.id = 0}},
    {.prob = 0.5, .evt = {.id = 1}},
  };
  CapyDistDiscreteOccurence cheatCoinOcc[2] = {
    {.prob = 0.25, .evt = {.id = 0}},
    {.prob = 0.75, .evt = {.id = 1}},
  };
  loop(i, (size_t)2) $(fairCoin.occ, set)(i, fairCoinOcc + i);
  loop(i, (size_t)2) $(cheatCoin.occ, set)(i, cheatCoinOcc + i);
  size_t sizeDist = 23;
  CapyDistDiscrete fairDist = CapyDistDiscreteCreate(sizeDist);
  fairDist.isEvtInMostProbable = IsEvtInMostProbableFair;
  CapyDistDiscrete cheatDist = CapyDistDiscreteCreate(sizeDist);
  cheatDist.isEvtInMostProbable = IsEvtInMostProbableCheat;
  loop(i, sizeDist) {
    CapyDistDiscreteOccurence* occ = $(fairDist.occ, getPtr)(i);
    occ->evt.id = i + 1;
    occ = $(cheatDist.occ, getPtr)(i);
    occ->evt.id = i + 1;
  }
  int nbExperiment = 10000;
  loop(i, nbExperiment) {
    size_t nbHead = 0;
    CapyDistEvt evt = CapyDistEvtCreate();
    loop(j, sizeDist) {
      evt = $(&rnd, getDistEvt)((CapyDist*)&fairCoin);
      nbHead += evt.id;
    }
    CapyDistDiscreteOccurence* occ = $(fairDist.occ, getPtr)(nbHead - 1);
    occ->prob += 1.0;
    nbHead = 0;
    loop(j, sizeDist) {
      evt = $(&rnd, getDistEvt)((CapyDist*)&cheatCoin);
      nbHead += evt.id;
    }
    occ = $(cheatDist.occ, getPtr)(nbHead - 1);
    occ->prob += 1.0;
  }
  double pValue = 0.05;
  double statisticalPower = 0.8;
  CapyFHT* fht =
    CapyFHTAlloc(
      statisticalPower, pValue, (CapyDist*)&cheatDist, (CapyDist*)&fairDist);
  int check[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1
  };
  loop(i, sizeDist) {
    CapyDistEvt evt = CapyDistEvtCreate();
    evt.id = i + 1;
    bool isCheater = $(fht, isEvtMatchingNullHypo)(&evt);
    CUTEST_ASSERT(isCheater == check[i], "cheater undetected %lu", i);
  }
  CapyFHTFree(&fht);
  $(&fairDist, destruct)();
  $(&cheatDist, destruct)();
  $(&fairCoin, destruct)();
  $(&cheatCoin, destruct)();
  $(&rnd, destruct)();
}
