#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Alloc/free CapyGaleShapleyPairing") {
  CapyGaleShapleyPairing* pairing = CapyGaleShapleyPairingAlloc();
  CapyGaleShapleyPairing* ptr = pairing;
  CapyGaleShapleyPairingFree(&pairing);
  CUTEST_ASSERT(
    ptr != NULL && pairing == NULL,
    "Alloc/Free failed, ptr=%p, pairing=%p", (void*)ptr, (void*)pairing);
}

CUTEST(test002, "Pairing example (1)") {
  CapyGaleShapleyPairing* pairing = CapyGaleShapleyPairingAlloc();
  size_t sizeSet = 5;
  CapyMat weightA = {
    .nbCol = sizeSet, .nbRow = sizeSet,
    .vals = (double[25]){
      1.0 / 5.0, 1.0 / 1.0, 1.0 / 2.0, 1.0 / 4.0, 1.0 / 3.0,
      1.0 / 4.0, 1.0 / 1.0, 1.0 / 3.0, 1.0 / 2.0, 1.0 / 5.0,
      1.0 / 5.0, 1.0 / 3.0, 1.0 / 2.0, 1.0 / 4.0, 1.0 / 1.0,
      1.0 / 1.0, 1.0 / 5.0, 1.0 / 4.0, 1.0 / 3.0, 1.0 / 2.0,
      1.0 / 4.0, 1.0 / 3.0, 1.0 / 2.0, 1.0 / 1.0, 1.0 / 5.0,
    }
  };
  CapyMat weightB = {
    .nbCol = sizeSet, .nbRow = sizeSet,
    .vals = (double[25]){
      1.0 / 1.0, 1.0 / 2.0, 1.0 / 4.0, 1.0 / 3.0, 1.0 / 5.0,
      1.0 / 3.0, 1.0 / 5.0, 1.0 / 1.0, 1.0 / 2.0, 1.0 / 4.0,
      1.0 / 5.0, 1.0 / 4.0, 1.0 / 2.0, 1.0 / 1.0, 1.0 / 3.0,
      1.0 / 1.0, 1.0 / 5.0, 1.0 / 3.0, 1.0 / 2.0, 1.0 / 4.0,
      1.0 / 4.0, 1.0 / 2.0, 1.0 / 3.0, 1.0 / 5.0, 1.0 / 1.0,
    }
  };
  size_t* pairs = $(pairing, run)(&weightA, &weightB);
  size_t check[5] = {1, 2, 4, 0, 3};
  CUTEST_ASSERT(
    pairs[0] == check[0] &&
    pairs[1] == check[1] &&
    pairs[2] == check[2] &&
    pairs[3] == check[3] &&
    pairs[4] == check[4],
    "Pairing failed {%lu, %lu, %lu, %lu, %lu} != {%lu, %lu, %lu, %lu, %lu}",
    pairs[0], pairs[1], pairs[2], pairs[3], pairs[4],
    check[0], check[1], check[2], check[3], check[4]);
  free(pairs);
  CapyGaleShapleyPairingFree(&pairing);
}
