#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Alloc/Free, load image, set latitude and longitude") {
  CapyGeoMap* geomap = CapyGeoMapAlloc();
  $(geomap, loadImgFromPath)("UnitTests/TestGeoMap/test01.png");
  $(geomap, setLatitudeRange)((CapyRangeLongLat){.min = 42.3, .max = 51.1});
  $(geomap, setLongitudeRange)((CapyRangeLongLat){.min = -4.9, .max = 8.3});
  CapyImg* checkImg = CapyImgLoadFromPath("UnitTests/TestGeoMap/test01.png");
  CUTEST_ASSERT(
    fabs(geomap->rangeLatitude.min - 42.3) < 1e-6 &&
    fabs(geomap->rangeLatitude.max - 51.1) < 1e-6 &&
    fabs(geomap->rangeLongitude.min - -4.9) < 1e-6 &&
    fabs(geomap->rangeLongitude.max - 8.3) < 1e-6 &&
    $(geomap->img, isSame)(checkImg),
    "Creation of geomap failed");
  CapyGeoMapFree(&geomap);
  CapyImgFree(&checkImg);
}

CUTEST(test002, "Get image position from latitude and longitude") {
  CapyGeoMap* geomap = CapyGeoMapAlloc();
  $(geomap, loadImgFromPath)("UnitTests/TestGeoMap/test01.png");
  $(geomap, setLatitudeRange)((CapyRangeLongLat){.min = 42.3, .max = 51.1});
  $(geomap, setLongitudeRange)((CapyRangeLongLat){.min = -4.9, .max = 8.3});
  CapyGeoMapCoord coord = {.latitude = 49.1829, .longitude = -0.3707};
  CapyImgPos pos = $(geomap, getImgPos)(coord);
  CUTEST_ASSERT(
    pos.x == 205 && pos.y == 127,
    "pos.x = %d, pos.y = %d", pos.x, pos.y);
  CapyGeoMapFree(&geomap);
}

CUTEST(test003, "Get latitude and longitude from image position") {
  CapyGeoMap* geomap = CapyGeoMapAlloc();
  $(geomap, loadImgFromPath)("UnitTests/TestGeoMap/test01.png");
  $(geomap, setLatitudeRange)((CapyRangeLongLat){.min = 42.3, .max = 51.1});
  $(geomap, setLongitudeRange)((CapyRangeLongLat){.min = -4.9, .max = 8.3});
  CapyImgPos pos = {.x = 203, .y = 126};
  CapyGeoMapCoord coord = $(geomap, getImgCoord)(pos);
  CUTEST_ASSERT(
    fabs(coord.latitude - 49.198113) < 1e-6 &&
    fabs(coord.longitude + 0.426544) < 1e-6,
    "latitude = %lf, longitude = %lf", coord.latitude, coord.longitude);
  CapyGeoMapFree(&geomap);
}
