#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Triangle") {
  CapyTriangle* tri = CapyTriangleAlloc();
  CUTEST_ASSERT(equal(tri->corners[0].x, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(tri->corners[0].y, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(tri->corners[1].x, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(tri->corners[1].y, 1.0), "initialisation failed");
  CUTEST_ASSERT(equal(tri->corners[2].x, 1.0), "initialisation failed");
  CUTEST_ASSERT(equal(tri->corners[2].y, 0.0), "initialisation failed");
  double area = $(tri, getArea)();
  CUTEST_ASSERT(equal(area, 0.5), "getArea failed %lf!=0.5", area);
  CapyTriangleFree(&tri);
  CUTEST_ASSERT(tri == NULL, "tri not reset");
}

CUTEST(test002, "Quadrilateral") {
  CapyQuadrilateral* quad = CapyQuadrilateralAlloc();
  CUTEST_ASSERT(equal(quad->corners[0].x, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(quad->corners[0].y, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(quad->corners[1].x, 1.0), "initialisation failed");
  CUTEST_ASSERT(equal(quad->corners[1].y, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(quad->corners[2].x, 1.0), "initialisation failed");
  CUTEST_ASSERT(equal(quad->corners[2].y, 1.0), "initialisation failed");
  CUTEST_ASSERT(equal(quad->corners[3].x, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(quad->corners[3].y, 1.0), "initialisation failed");
  double area = $(quad, getArea)();
  CUTEST_ASSERT(equal(area, 1.0), "getArea failed %lf!=1.0", area);
  CapyQuadrilateralFree(&quad);
  CUTEST_ASSERT(quad == NULL, "quad not reset");
}

CUTEST(test003, "QuadrilateralBilinearCoord") {
  CapyQuadrilateral quad = CapyQuadrilateralCreate();
  double pos[2] = {0.75, 1.25};
  double coords[2] = {0.0, 0.0};
  $(&quad, getBilinearCoords)(pos, coords);
  CUTEST_ASSERT(
    equal(coords[0], pos[0]), "getBilinearCoords failed %lf", coords[0]);
  CUTEST_ASSERT(
    equal(coords[1], pos[1]), "getBilinearCoords failed %lf", coords[1]);
  $(&quad, destruct)();
}

CUTEST(test004, "Padding (1)") {
  CUTEST_ASSERT(
    offsetof(CapyPoint2D, x) == offsetof(CapyPoint2D, coords[0]),
    "offset of x and coords[0] doesn't match %lu!=%lu",
    offsetof(CapyPoint2D, x), offsetof(CapyPoint2D, coords[0]));
  CUTEST_ASSERT(
    offsetof(CapyPoint2D, y) == offsetof(CapyPoint2D, coords[1]),
    "offset of y and coords[1] doesn't match %lu!=%lu",
    offsetof(CapyPoint2D, y), offsetof(CapyPoint2D, coords[1]));
}

CUTEST(test005, "Padding (2)") {
  CUTEST_ASSERT(
    offsetof(CapyPoint2D, x) ==
      offsetof(CapyPoint2D, coords[0]),
    "offset of x and coords[0] doesn't match %lu!=%lu",
    offsetof(CapyPoint2D, x),
    offsetof(CapyPoint2D, coords[0]));
  CUTEST_ASSERT(
    offsetof(CapyPoint2D, y) ==
      offsetof(CapyPoint2D, coords[1]),
    "offset of y and coords[1] doesn't match %lu!=%lu",
    offsetof(CapyPoint2D, y),
    offsetof(CapyPoint2D, coords[1]));
}

CUTEST(test006, "Circle") {
  CapyCircle* circle = CapyCircleAlloc();
  CUTEST_ASSERT(equal(circle->center.x, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(circle->center.y, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(circle->radius, 1.0), "initialisation failed");
  double area = $(circle, getArea)();
  CUTEST_ASSERT(equal(area, M_PI), "getArea failed %lf!=pi", area);
  CapyCircleFree(&circle);
  CUTEST_ASSERT(circle == NULL, "circle not reset");
}

CUTEST(test007, "Segment2D") {
  CapySegment* seg = CapySegmentAlloc();
  CUTEST_ASSERT(equal(seg->points[0].x, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(seg->points[0].y, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(seg->points[1].x, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(seg->points[1].y, 1.0), "initialisation failed");
  double area = $(seg, getArea)();
  CUTEST_ASSERT(equal(area, 0.0), "getArea failed %lf!=0.0", area);
  CapySegmentFree(&seg);
  CUTEST_ASSERT(seg == NULL, "seg not reset");
}

CUTEST(test008, "Rectangle") {
  CapyRectangle* rect = CapyRectangleAlloc();
  CUTEST_ASSERT(equal(rect->corners[0].x, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(rect->corners[0].y, 0.0), "initialisation failed");
  CUTEST_ASSERT(equal(rect->corners[1].x, 1.0), "initialisation failed");
  CUTEST_ASSERT(equal(rect->corners[1].y, 1.0), "initialisation failed");
  double area = $(rect, getArea)();
  CUTEST_ASSERT(equal(area, 1.0), "getArea failed %lf!=1.0", area);
  CapyRectangleFree(&rect);
  CUTEST_ASSERT(rect == NULL, "rect not reset");
}

CUTEST(test009, "Triangle barycentric coordinates") {
  CapyTriangle* tri = CapyTriangleAlloc();
  tri->corners[0].x = 0.0;
  tri->corners[0].y = 0.0;
  tri->corners[1].x = 1.0;
  tri->corners[1].y = 0.0;
  tri->corners[2].x = 0.0;
  tri->corners[2].y = 1.0;
  double coords[5][3] = {0};
  CapyPoint2D pos[5] = {
    {.x = 0.0, .y = 0.0},
    {.x = 1.0, .y = 0.0},
    {.x = 0.0, .y = 1.0},
    {.x = 0.5, .y = 0.0},
    {.x = 0.0, .y = 0.5},
  };
  loop(i, 5) $(tri, getBarycentricCoord)(pos + i, coords[i]);
  double check[5][3] = {
    {1, 0, 0}, {0, 1, 0}, {0, 0, 1}, {0.5, 0.5, 0}, {0.5, 0, 0.5}
  };
  bool ok = true;
  loop(i, 5) {
    ok &= (
      equal(coords[i][0], check[i][0]) &&
      equal(coords[i][1], check[i][1]) &&
      equal(coords[i][2], check[i][2]));
  }
  CUTEST_ASSERT(ok, "getBarycentricCoord failed");
  CapyTriangleFree(&tri);
}

CUTEST(test010, "Segment2D intersection (1)") {
  CapySegment segA = CapySegmentCreate();
  segA.points[0].x = 0.0;
  segA.points[0].y = 0.0;
  segA.points[1].x = 2.0;
  segA.points[1].y = 0.0;
  CapySegment segB = CapySegmentCreate();
  segB.points[0].x = 1.0;
  segB.points[0].y = 1.0;
  segB.points[1].x = 1.0;
  segB.points[1].y = -1.0;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  bool const flagStrict = true;
  $(&inter, getIntersectSegments)(&segA, &segB, flagStrict);
  CUTEST_ASSERT(
    inter.nbPoint == 1 &&
    equal(inter.points[0].x, 1.0) &&
    equal(inter.points[0].y, 0.0),
    "getIntersectionSegments failed");
  $(&inter, destruct)();
  $(&segA, destruct)();
  $(&segB, destruct)();
}

CUTEST(test011, "Segment2D intersection (2)") {
  CapySegment segA = CapySegmentCreate();
  segA.points[0].x = 0.0;
  segA.points[0].y = 0.0;
  segA.points[1].x = 2.0;
  segA.points[1].y = 0.0;
  CapySegment segB = CapySegmentCreate();
  segB.points[0].x = 1.0;
  segB.points[0].y = 2.0;
  segB.points[1].x = 1.0;
  segB.points[1].y = 1.0;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  bool const flagStrict = true;
  $(&inter, getIntersectSegments)(&segA, &segB, flagStrict);
  CUTEST_ASSERT(
    inter.nbPoint == 0,
    "GetIntersectionSegments failed");
  $(&inter, destruct)();
  $(&segA, destruct)();
  $(&segB, destruct)();
}

CUTEST(test012, "Segment2D intersection (3)") {
  CapySegment segA = CapySegmentCreate();
  segA.points[0].x = 0.0;
  segA.points[0].y = 0.0;
  segA.points[1].x = 2.0;
  segA.points[1].y = 0.0;
  CapySegment segB = CapySegmentCreate();
  segB.points[0].x = 1.0;
  segB.points[0].y = 2.0;
  segB.points[1].x = 1.0;
  segB.points[1].y = 1.0;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  bool const flagStrict = false;
  $(&inter, getIntersectSegments)(&segA, &segB, flagStrict);
  CUTEST_ASSERT(
    inter.nbPoint == 1 &&
    equal(inter.points[0].x, 1.0) &&
    equal(inter.points[0].y, 0.0),
    "getIntersectionSegments failed");
  $(&inter, destruct)();
  $(&segA, destruct)();
  $(&segB, destruct)();
}

CUTEST(test013, "Circle2D intersection (1)") {
  CapyCircle circleA = CapyCircleCreate();
  circleA.center.x = 0.0;
  circleA.center.y = 0.0;
  circleA.radius = 1.0;
  CapyCircle circleB = CapyCircleCreate();
  circleB.center.x = 3.0;
  circleB.center.y = 0.0;
  circleB.radius = 1.0;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  $(&inter, getIntersectCircles)(&circleA, &circleB);
  CUTEST_ASSERT(
    inter.nbPoint == 0,
    "getIntersectionCircles failed");
  $(&inter, destruct)();
  $(&circleA, destruct)();
  $(&circleB, destruct)();
}

CUTEST(test014, "Circle2D intersection (2)") {
  CapyCircle circleA = CapyCircleCreate();
  circleA.center.x = 0.0;
  circleA.center.y = 0.0;
  circleA.radius = 1.0;
  CapyCircle circleB = CapyCircleCreate();
  circleB.center.x = 2.0;
  circleB.center.y = 0.0;
  circleB.radius = 1.0;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  $(&inter, getIntersectCircles)(&circleA, &circleB);
  CUTEST_ASSERT(
    inter.nbPoint == 1 &&
    equald(inter.points[0].x, 1.0) &&
    equald(inter.points[0].y, 0.0),
    "getIntersectionCircles failed");
  $(&inter, destruct)();
  $(&circleA, destruct)();
  $(&circleB, destruct)();
}

CUTEST(test015, "Circle2D intersection (3)") {
  CapyCircle circleA = CapyCircleCreate();
  circleA.center.x = 0.0;
  circleA.center.y = 0.0;
  circleA.radius = 1.0;
  CapyCircle circleB = CapyCircleCreate();
  circleB.center.x = 1.0;
  circleB.center.y = 0.0;
  circleB.radius = 1.0;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  $(&inter, getIntersectCircles)(&circleA, &circleB);
  CUTEST_ASSERT(
    inter.nbPoint == 2 &&
    equald(inter.points[0].x, 0.5) &&
    equald(inter.points[0].y, sqrt(0.75)) &&
    equald(inter.points[1].x, 0.5) &&
    equald(inter.points[1].y, -sqrt(0.75)),
    "getIntersectionCircles failed");
  $(&inter, destruct)();
  $(&circleA, destruct)();
  $(&circleB, destruct)();
}

CUTEST(test016, "Circle2D intersection (4)") {
  CapyCircle circleA = CapyCircleCreate();
  circleA.center.x = 0.0;
  circleA.center.y = 0.0;
  circleA.radius = 1.0;
  CapyCircle circleB = CapyCircleCreate();
  circleB.center.x = 0.0;
  circleB.center.y = 3.0;
  circleB.radius = 2.0;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  $(&inter, getIntersectCircles)(&circleA, &circleB);
  CUTEST_ASSERT(
    inter.nbPoint == 1 &&
    equald(inter.points[0].x, 0.0) &&
    equald(inter.points[0].y, 1.0),
    "getIntersectionCircles failed");
  $(&inter, destruct)();
  $(&circleA, destruct)();
  $(&circleB, destruct)();
}

CUTEST(test017, "Circle2D intersection (5)") {
  CapyCircle circleA = CapyCircleCreate();
  circleA.center.x = 0.0;
  circleA.center.y = 0.0;
  circleA.radius = 1.0;
  CapyCircle circleB = CapyCircleCreate();
  circleB.center.x = 0.0;
  circleB.center.y = 2.0;
  circleB.radius = 2.5;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  $(&inter, getIntersectCircles)(&circleA, &circleB);
  CUTEST_ASSERT(
    inter.nbPoint == 2 &&
    equald(inter.points[0].x, -0.949917759598166489) &&
    equald(inter.points[0].y, -0.31250) &&
    equald(inter.points[1].x, 0.949917759598166489) &&
    equald(inter.points[1].y, -0.31250),
    "getIntersectionCircles failed");
  $(&inter, destruct)();
  $(&circleA, destruct)();
  $(&circleB, destruct)();
}

CUTEST(test018, "Segment/Circle2D intersection (1)") {
  CapyCircle circle = CapyCircleCreate();
  circle.center.x = 0.0;
  circle.center.y = 0.0;
  circle.radius = 1.0;
  CapySegment seg = CapySegmentCreate();
  seg.points[0].x = -2.0;
  seg.points[0].y = 0.0;
  seg.points[1].x = 2.0;
  seg.points[1].y = 0.0;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  bool const flagStrict = true;
  $(&inter, getIntersectSegmentCircle)(&seg, &circle, flagStrict);
  CUTEST_ASSERT(
    inter.nbPoint == 2 &&
    equald(inter.points[0].x, -1.0) &&
    equald(inter.points[0].y, 0.0) &&
    equald(inter.points[1].x, 1.0) &&
    equald(inter.points[1].y, 0.0),
    "getIntersectionSegmentCircle failed");
  $(&inter, destruct)();
  $(&circle, destruct)();
  $(&seg, destruct)();
}

CUTEST(test019, "Segment/Circle2D intersection (2)") {
  CapyCircle circle = CapyCircleCreate();
  circle.center.x = 0.0;
  circle.center.y = 0.0;
  circle.radius = 1.0;
  CapySegment seg = CapySegmentCreate();
  seg.points[0].x = -0.5;
  seg.points[0].y = 0.0;
  seg.points[1].x = 0.5;
  seg.points[1].y = 0.0;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  bool const flagStrict = true;
  $(&inter, getIntersectSegmentCircle)(&seg, &circle, flagStrict);
  CUTEST_ASSERT(
    inter.nbPoint == 0,
    "getIntersectionSegmentCircle failed");
  $(&inter, destruct)();
  $(&circle, destruct)();
  $(&seg, destruct)();
}

CUTEST(test020, "Segment/Circle2D intersection (3)") {
  CapyCircle circle = CapyCircleCreate();
  circle.center.x = 0.0;
  circle.center.y = 0.0;
  circle.radius = 1.0;
  CapySegment seg = CapySegmentCreate();
  seg.points[0].x = -0.5;
  seg.points[0].y = 0.0;
  seg.points[1].x = 0.5;
  seg.points[1].y = 0.0;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  bool const flagStrict = false;
  $(&inter, getIntersectSegmentCircle)(&seg, &circle, flagStrict);
  CUTEST_ASSERT(
    inter.nbPoint == 2 &&
    equald(inter.points[0].x, -1.0) &&
    equald(inter.points[0].y, 0.0) &&
    equald(inter.points[1].x, 1.0) &&
    equald(inter.points[1].y, 0.0),
    "getIntersectionSegmentCircle failed");
  $(&inter, destruct)();
  $(&circle, destruct)();
  $(&seg, destruct)();
}

CUTEST(test021, "Orientation of the intersection of two circles") {
  CapyCircle circleA = CapyCircleCreate();
  circleA.center.x = -1.0;
  circleA.center.y = 0.0;
  circleA.radius = 2.0;
  CapyCircle circleB = CapyCircleCreate();
  circleB.center.x = 1.0;
  circleB.center.y = 0.0;
  circleB.radius = 2.0;
  CapyGeometry2DIntersection inter = CapyGeometry2DIntersectionCreate();
  $(&inter, getIntersectCircles)(&circleA, &circleB);
  bool isOk =
    inter.nbPoint == 2 &&
    fabs(inter.points[0].x - 0.0) < 1e-6 &&
    fabs(inter.points[0].y - 1.732051) < 1e-6 &&
    fabs(inter.points[1].x - 0.0) < 1e-6 &&
    fabs(inter.points[1].y + 1.732051) < 1e-6;
  $(&inter, getIntersectCircles)(&circleB, &circleA);
  isOk &=
    inter.nbPoint == 2 &&
    fabs(inter.points[0].x - 0.0) < 1e-6 &&
    fabs(inter.points[0].y + 1.732051) < 1e-6 &&
    fabs(inter.points[1].x - 0.0) < 1e-6 &&
    fabs(inter.points[1].y - 1.732051) < 1e-6;
  CUTEST_ASSERT(isOk, "orientation of getIntersectionCircles failed");
  $(&inter, destruct)();
  $(&circleA, destruct)();
  $(&circleB, destruct)();
}
