#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Graph operations") {
  CapyGraph* graph = CapyGraphAlloc();
  size_t size = $(graph->nodes, getSize)();
  CUTEST_ASSERT(size == 0, "unexpected size %ld", size);
  $(graph, addNode)(CapyGraphNodeCreate(0));
  $(graph, addNode)(CapyGraphNodeCreate(1));
  size = $(graph->nodes, getSize)();
  CUTEST_ASSERT(size == 2, "unexpected size %ld", size);
  $(graph, linkNodes)(0, 1);
  size = $(graph->links, getSize)();
  CUTEST_ASSERT(size == 1, "unexpected size %ld", size);
  $(graph, updateConnectivityMat)();
  int check[] = {0, 1, 1, 0};
  loop(i, 4) {
    CUTEST_ASSERT(
      graph->connectivityMat[i] == check[i],
      "updateConnectivityMat failed [%d]=%d != %d",
      i, graph->connectivityMat[i], check[i]);
  }
  $(graph, addNode)(CapyGraphNodeCreate(2));
  $(graph, linkNodes)(2, 1);
  $(graph, updateConnectivityMat)();
  $(graph, updateLinkDistanceMat)();
  uint64_t dist[] = {0, 1, 2, 1, 0, 1, 2, 1, 0};
  loop(i, 9) {
    CUTEST_ASSERT(
      graph->linkDistanceMat[i] == dist[i],
      "updateLinkDistanceMat failed [%d]=%lu != %lu",
      i, graph->linkDistanceMat[i], dist[i]);
  }
  CapyGraphFree(&graph);
  CUTEST_ASSERT(graph == NULL, "graph not reset");
}

CUTEST(test002, "PageRank") {
  CapyGraph* graph = CapyGraphAlloc();
  graph->directed = true;
  loop(i, (size_t)5) $(graph, addNode)(CapyGraphNodeCreate(i));
  $(graph, linkNodes)(0, 4);
  $(graph, linkNodes)(1, 0);
  $(graph, linkNodes)(2, 0);
  $(graph, linkNodes)(3, 1);
  $(graph, linkNodes)(3, 2);
  $(graph, linkNodes)(4, 2);
  $(graph, linkNodes)(4, 3);
  $(graph, pageRank)(100);
  double ranks[5] =
    {0.25419178, 0.13803151, 0.13803151, 0.20599017, 0.26375504};
  forEach(node, graph->nodes->iter) {
    CUTEST_ASSERT(
      fabs(node.pageRank - ranks[graph->nodes->iter.idx]) < 1e-6,
      "rank=%lf != %lf", node.pageRank, ranks[graph->nodes->iter.idx]);
  }
  CapyGraphFree(&graph);
}
