#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Plot density distribution for iris dataset") {
  CapyGraphPlotter* plotter = CapyGraphPlotterAlloc();
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("Resources/iris.csv");
  CapyImgDims dims = {.width = 400, .height = 200};
  size_t nbBin = 10;
  size_t iCatField = $(dataset, getIdxFieldFromName)("class");
  CapyImg* img =
    $(plotter, plotAllDensityDistributionsGivenCatField)(
      dataset, iCatField, &dims, nbBin);
  CapyImg* imgCheck =
    CapyImgLoadFromPath("UnitTests/TestGraphPlotter/check001.png");
  CUTEST_ASSERT(
    $(img, isSame)(imgCheck),
    "plotAllDensityDistributionsGivenCatField failed");
  CapyImgFree(&img);
  CapyImgFree(&imgCheck);
  CapyDatasetFree(&dataset);
  CapyGraphPlotterFree(&plotter);
}

CUTEST(test002, "Plot correlation graph for iris dataset (pearson)") {
  CapyGraphPlotter* plotter = CapyGraphPlotterAlloc();
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("Resources/iris.csv");
  CapyImgDims dims = {.width = 400, .height = 200};
  CapyImg* img =
    $(plotter, plotAllCorrelationGraph)(dataset, &dims,
    capyGraphPlotterTypeCorrelation_pearson);
  CapyImg* imgCheck =
    CapyImgLoadFromPath("UnitTests/TestGraphPlotter/check002.png");
  CUTEST_ASSERT(
    $(img, isSame)(imgCheck), "plotAllCorrelationGraph failed");
  CapyImgFree(&img);
  CapyImgFree(&imgCheck);
  CapyDatasetFree(&dataset);
  CapyGraphPlotterFree(&plotter);
}

CUTEST(test003, "Plot correlation graph for iris dataset (distance)") {
  CapyGraphPlotter* plotter = CapyGraphPlotterAlloc();
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("Resources/iris.csv");
  CapyImgDims dims = {.width = 400, .height = 200};
  CapyImg* img =
    $(plotter, plotAllCorrelationGraph)(dataset, &dims,
    capyGraphPlotterTypeCorrelation_distance);
  CapyImg* imgCheck =
    CapyImgLoadFromPath("UnitTests/TestGraphPlotter/check003.png");
  CUTEST_ASSERT(
    $(img, isSame)(imgCheck), "plotAllCorrelationGraph failed");
  CapyImgFree(&img);
  CapyImgFree(&imgCheck);
  CapyDatasetFree(&dataset);
  CapyGraphPlotterFree(&plotter);
}
