#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Greedy operations") {
  CapyGreedy* greedy = CapyGreedyAlloc();
  char const* lbls[8] = {
    "wine", "beer", "pizza", "burger",
    "cola", "apple", "donut", "cake",
  };
  double gains[8] = {
    89, 90, 95, 100, 90, 79, 50, 10,
  };
  double costs[8] = {
    123, 154, 258, 354, 365, 150, 95, 195,
  };
  uint64_t qtys[8] = {
    1, 1, 1, 1, 1, 1, 1, 1,
  };
  $(&(greedy->objects), resize)(8);
  loop(i, (size_t)8) {
    CapyGreedyObject obj = {
      .cost = costs[i],
      .gain = gains[i],
      .qty = qtys[i],
      .ptr = lbls[i],
    };
    $(&(greedy->objects), set)(i, &obj);
  }
  double maxCalories = 750.0;
  CapyGreedyResult res = $(greedy, select)(maxCalories);
  CUTEST_ASSERT(fabs(res.cost - 735.0) < 1e-6, "select failed %lf", res.cost);
  CUTEST_ASSERT(fabs(res.gain - 284.0) < 1e-6, "select failed %lf", res.gain);
  uint64_t checkQtys[8] = {
    1, 1, 0, 0, 1, 0, 0, 0,
  };
  forEach(object, greedy->objects.iter) {
    CUTEST_ASSERT(
      object.qty == checkQtys[greedy->objects.iter.idx],
      "select failed [%lu]=%lu != %lu",
      greedy->objects.iter.idx, object.qty,
      checkQtys[greedy->objects.iter.idx]);
  }
  CapyGreedyFree(&greedy);
}
