#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Creation/destruction FNV1a") {
  CapyFNV1aHashFun* hashfun = CapyFNV1aHashFunAlloc();
  CUTEST_ASSERT(
    hashfun->prime == 0x100000001b3UL &&
    hashfun->offset == 0xcbf29ce484222325UL,
    "prime=%lx != 0x100000001b3 or offset=%lx != 0xcbf29ce484222325",
    hashfun->prime, hashfun->offset);
  CapyFNV1aHashFunFree(&hashfun);
}

CUTEST(test002, "Evaluation FNV1a") {
  CapyFNV1aHashFun* hashfun = CapyFNV1aHashFunAlloc();
  char const* data = "abc";
  uint64_t hash = $(hashfun, eval)(data, 3);
  CUTEST_ASSERT(
    hash == 16654208175385433931UL,
    "hash=%lu != 16654208175385433931", hash);
  CapyFNV1aHashFunFree(&hashfun);
}
