#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
static void PrintRow(
  FILE* const stream,
  void* const data,
  void* const user) {
  CapyListSize* const indices = (CapyListSize*)data;
  size_t size = $(indices, getSize)();
  if(size > 0) {
    size_t index = $(indices, getHead)();
    CapyDataset* const dataset = (CapyDataset*)user;
    char const* const out = dataset->rows[index].fields[4];
    fprintf(stream, " %lu %s", index, out);
  }
}

#endif
CUTEST(test001, "Alloc/free") {
  CapyHierarchicalClustering* clustering = CapyHierarchicalClusteringAlloc();
  CapyHierarchicalClustering* ptr = clustering;
  CapyHierarchicalClusteringFree(&clustering);
  CUTEST_ASSERT(
    ptr != NULL && clustering == NULL,
    "Alloc/free failed");
}

CUTEST(test002, "Cluster iris dataset using DIANA") {
  char const* const originalLocale = setlocale(LC_ALL, NULL);
  setlocale(LC_ALL, "");
  CapyHierarchicalClustering* clustering = CapyHierarchicalClusteringAlloc();
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("Resources/iris.csv");
  CapyDatasetRowCluster* clusters = $(clustering, dianaClustering)(dataset);
  FILE* stream = fopen("UnitTests/TestHierarchicalClustering/iris.txt", "w");
  $(clusters, print)(stream, PrintRow, dataset);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestHierarchicalClustering/iris.txt "
      "UnitTests/TestHierarchicalClustering/iris_check.txt") == 0,
    "TestHierarchicalClustering/iris.txt and "
    "TestHierarchicalClustering/iris_check.txt differ.");
  CapyDatasetRowClusterFree(&clusters);
  CapyHierarchicalClusteringFree(&clustering);
  CapyDatasetFree(&dataset);
  setlocale(LC_ALL, originalLocale);
}

CUTEST(test003, "Cluster iris dataset using fast DIANA") {
  char const* const originalLocale = setlocale(LC_ALL, NULL);
  setlocale(LC_ALL, "");
  CapyHierarchicalClustering* clustering = CapyHierarchicalClusteringAlloc();
  CapyDataset* dataset = CapyDatasetAlloc();
  $(dataset, loadFromPath)("Resources/iris.csv");
  CapyDatasetRowCluster* clusters = $(clustering, fastDianaClustering)(dataset);
  FILE* stream =
    fopen("UnitTests/TestHierarchicalClustering/fast_iris.txt", "w");
  $(clusters, print)(stream, PrintRow, dataset);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestHierarchicalClustering/fast_iris.txt "
      "UnitTests/TestHierarchicalClustering/fast_iris_check.txt") == 0,
    "TestHierarchicalClustering/fast_iris.txt and "
    "TestHierarchicalClustering/fast_iris_check.txt differ.");
  CapyDatasetRowClusterFree(&clusters);
  CapyHierarchicalClusteringFree(&clustering);
  CapyDatasetFree(&dataset);
  setlocale(LC_ALL, originalLocale);
}
