#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Combination (1)") {
  CapyIdxCombination* combi = CapyIdxCombinationAlloc(2);
  combi->ranges[0].min = 1;
  combi->ranges[0].max = 3;
  combi->ranges[1].min = 0;
  combi->ranges[1].max = 2;
  size_t check[9][2] = {
    {1, 0},
    {2, 0},
    {3, 0},
    {1, 1},
    {2, 1},
    {3, 1},
    {1, 2},
    {2, 2},
    {3, 2},
  };
  forEach(c, *combi) {
    CUTEST_ASSERT(
      c[0] == check[combi->idx][0] && c[1] == check[combi->idx][1],
      "unexpected combination #%lu [%ld,%ld] != [%ld,%ld]",
      combi->idx, c[0], c[1], check[combi->idx][0], check[combi->idx][1]);
  }
  CapyIdxCombinationFree(&combi);
}
