#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Gaussian kernel") {
  CapyImgKernel* kernel = CapyImgKernelAlloc(2);
  CUTEST_ASSERT(kernel->size == 2, "unexpected size %d", kernel->size);
  loop(i, 25) {
    if(i == 12) {
      CUTEST_ASSERT(
        equal(kernel->mat[i], 1.0), "kernel initialisation failed %d", i);
    } else {
      CUTEST_ASSERT(
        equal(kernel->mat[i], 0.0), "kernel initialisation failed %d", i);
    }
  }
  $(kernel, setToGaussianBlur)(1.0);
  double check[25] = {
    0.00296901674395049766, 0.01330620989101365288,
    0.02193823127971464282, 0.01330620989101365288,
    0.00296901674395049766, 0.01330620989101365288,
    0.05963429543618013057, 0.09832033134884575476,
    0.05963429543618013057, 0.01330620989101365288,
    0.02193823127971464282, 0.09832033134884575476,
    0.16210282163712660952, 0.09832033134884575476,
    0.02193823127971464282, 0.01330620989101365288,
    0.05963429543618013057, 0.09832033134884575476,
    0.05963429543618013057, 0.01330620989101365288,
    0.00296901674395049766, 0.01330620989101365288,
    0.02193823127971464282, 0.01330620989101365288,
    0.00296901674395049766
  };
  loop(i, 25) {
    CUTEST_ASSERT(
      equal(check[i], kernel->mat[i]),
      "setToGaussianBlur failed [%d]=%lf != %lf", i, kernel->mat[i], check[i]);
  }
  CapyImg* img = CapyImgLoadFromPath("UnitTests/TestImgKernel/test005.png");
  CapyImg* res = $(kernel, apply)(img);
  CapyImg* imgCheck =
    CapyImgLoadFromPath("UnitTests/TestImgKernel/test005gaussianblur.png");
  bool isSame = $(res, isSame)(imgCheck);
  CUTEST_ASSERT(isSame, "apply failed");
  $(kernel, setToDerivativeGaussianBlur)(1.0, 0);
  CapyImgFree(&res);
  res = $(kernel, apply)(img);
  $(res, cleanupPixelVals)();
  CapyImgFree(&imgCheck);
  imgCheck = CapyImgLoadFromPath(
    "UnitTests/TestImgKernel/test005derivativegaussianblur0.png");
  isSame = $(res, isSame)(imgCheck);
  CUTEST_ASSERT(isSame, "apply failed");
  CapyImgFree(&res);
  $(kernel, setToDerivativeGaussianBlur)(1.0, 1);
  res = $(kernel, apply)(img);
  $(res, cleanupPixelVals)();
  CapyImgFree(&imgCheck);
  imgCheck = CapyImgLoadFromPath(
    "UnitTests/TestImgKernel/test005derivativegaussianblur1.png");
  isSame = $(res, isSame)(imgCheck);
  CUTEST_ASSERT(isSame, "apply failed");
  CapyImgFree(&img);
  CapyImgFree(&imgCheck);
  CapyImgFree(&res);
  CapyImgKernelFree(&kernel);
  CUTEST_ASSERT(kernel == NULL, "kernel not reset");
}

CUTEST(test002, "Sharpen kernel") {
  CapyImgKernel* kernel = CapyImgKernelAlloc(2);
  $(kernel, setToSharpen)();
  CapyImg* img = CapyImgLoadFromPath("UnitTests/TestImgKernel/test005.png");
  CapyImg* res = $(kernel, apply)(img);
  $(res, cleanupPixelVals)();
  CapyImg* imgCheck =
    CapyImgLoadFromPath("UnitTests/TestImgKernel/test005Sharpen.png");
  bool isSame = $(res, isSame)(imgCheck);
  CUTEST_ASSERT(isSame, "apply failed");
  CapyImgFree(&img);
  CapyImgFree(&imgCheck);
  CapyImgFree(&res);
  CapyImgKernelFree(&kernel);
}

CUTEST(test003, "Edge detection kernel") {
  CapyImgKernel* kernel = CapyImgKernelAlloc(2);
  $(kernel, setToEdgeDetection)();
  CapyImg* img = CapyImgLoadFromPath("UnitTests/TestImgKernel/test005.png");
  CapyImg* res = $(kernel, apply)(img);
  $(res, cleanupPixelVals)();
  CapyImg* imgCheck =
    CapyImgLoadFromPath("UnitTests/TestImgKernel/test005EdgeDetection.png");
  bool isSame = $(res, isSame)(imgCheck);
  CUTEST_ASSERT(isSame, "apply failed");
  CapyImgFree(&img);
  CapyImgFree(&imgCheck);
  CapyImgFree(&res);
  CapyImgKernelFree(&kernel);
}
