#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "KMeans operations") {
  CapyKMeans* kmeans = CapyKMeansAlloc();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestKMeans/test005.png", "rb");
  CapyPngFormat png = CapyPngFormatCreate();
  CapyImg* img = $(&png, loadImg)(&stream);
  CapyPointCloud* colors = $(img, getColorsAsPointCloud)();
  kmeans->typeInit = capyKMeanInit_rand;
  $(kmeans, run)(colors, colors->size / 100);
  $(kmeans, applyToImgColor)(img);
  $(&stream, open)("UnitTests/TestKMeans/test005rnd.png", "rb");
  CapyImg* check = $(&png, loadImg)(&stream);
  CUTEST_ASSERT($(img, isSame)(check), "applyToImgColor rnd failed");
  CapyImgFree(&check);
  kmeans->typeInit = capyKMeanInit_forgy;
  $(kmeans, run)(colors, colors->size / 100);
  CapyImgFree(&img);
  $(&stream, open)("UnitTests/TestKMeans/test005.png", "rb");
  img = $(&png, loadImg)(&stream);
  $(kmeans, applyToImgColor)(img);
  $(&stream, open)("UnitTests/TestKMeans/test005forgy.png", "rb");
  check = $(&png, loadImg)(&stream);
  CUTEST_ASSERT($(img, isSame)(check), "applyToImgColor forgy failed");
  CapyImgFree(&check);
  kmeans->typeInit = capyKMeanInit_plusplus;
  $(kmeans, run)(colors, colors->size / 100);
  CapyImgFree(&img);
  $(&stream, open)("UnitTests/TestKMeans/test005.png", "rb");
  img = $(&png, loadImg)(&stream);
  $(kmeans, applyToImgColor)(img);
  $(&stream, open)("UnitTests/TestKMeans/test005plusplus.png", "rb");
  check = $(&png, loadImg)(&stream);
  CUTEST_ASSERT($(img, isSame)(check), "applyToImgColor plusplus failed");
  CapyImgFree(&check);
  CapyKMeansFree(&kmeans);
  CapyImgFree(&img);
  $(&png, destruct)();
  $(&stream, destruct)();
  CapyPointCloudFree(&colors);
}
