#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Alloc/free CapyLightRay") {
  CapyLightRay* lightray = CapyLightRayAlloc();
  CUTEST_ASSERT(
    true,
    " ");
  CapyLightRayFree(&lightray);
}

CUTEST(test002, "Critical angle water/air") {
  double thetaCrit = CapyGetCriticalRefractiveAngle(
    capyRefractiveCoeffs[capyMaterialIdx_water],
    capyRefractiveCoeffs[capyMaterialIdx_air],
    CAPY_DEFAULT_WAVELENGTH);
  CUTEST_ASSERT(
    fabs(thetaCrit - 0.848678) < 1e-6,
    "CapyGetCriticalRefractiveAngle failed");
}

CUTEST(test003, "Critical angle glass/air") {
  double thetaCrit = CapyGetCriticalRefractiveAngle(
    capyRefractiveCoeffs[capyMaterialIdx_glass],
    capyRefractiveCoeffs[capyMaterialIdx_air],
    CAPY_DEFAULT_WAVELENGTH);
  CUTEST_ASSERT(
    fabs(thetaCrit - 0.709645) < 1e-6,
    "CapyGetCriticalRefractiveAngle failed");
}

CUTEST(test004, "Critical angle air/glass") {
  double thetaCrit = CapyGetCriticalRefractiveAngle(
    capyRefractiveCoeffs[capyMaterialIdx_air],
    capyRefractiveCoeffs[capyMaterialIdx_glass],
    CAPY_DEFAULT_WAVELENGTH);
  CUTEST_ASSERT(
    fabs(thetaCrit - M_PI_4) < 1e-6,
    "CapyGetCriticalRefractiveAngle failed");
}

CUTEST(test005, "Estimate refractive coefficient") {
  CapyRefractiveCoeff coeff =
    CapyEstimateRefractiveCoeffFromReflectiveIndex(0.04);
  CUTEST_ASSERT(
    fabs(coeff.vals[0] - 1.5) < 1e-6 &&
    fabs(coeff.vals[1] - 0.0) < 1e-6,
    "CapyEstimateRefractiveCoeffFromReflectiveIndex failed");
}

CUTEST(test006, "Refraction values air/water (1)") {
  CapyRefractionValue refraction = CapyGetRefraction(
    capyRefractiveCoeffs[capyMaterialIdx_air],
    capyRefractiveCoeffs[capyMaterialIdx_water],
    0.0);
  CUTEST_ASSERT(
    fabs(refraction.reflective - 0.020332) < 1e-6 &&
    fabs(refraction.transmissive - 0.979668) < 1e-6 &&
    fabs(refraction.theta - 0.0) < 1e-6,
    "CapyGetRefraction failed");
}

CUTEST(test007, "Refraction values air/water (2)") {
  CapyRefractionValue refraction = CapyGetRefraction(
    capyRefractiveCoeffs[capyMaterialIdx_air],
    capyRefractiveCoeffs[capyMaterialIdx_water],
    M_PI_4);
  CUTEST_ASSERT(
    fabs(refraction.reflective - 0.020332) < 1e-6 &&
    fabs(refraction.transmissive - 0.979668) < 1e-6 &&
    fabs(refraction.theta - 0.55933) < 1e-6,
    "CapyGetRefraction failed");
}

CUTEST(test008, "Refraction values water/air (1)") {
  CapyRefractionValue refraction = CapyGetRefraction(
    capyRefractiveCoeffs[capyMaterialIdx_water],
    capyRefractiveCoeffs[capyMaterialIdx_air],
    M_PI_4 * 1.5);
  CUTEST_ASSERT(
    fabs(refraction.reflective - 1.0) < 1e-6 &&
    fabs(refraction.transmissive - 0.0) < 1e-6 &&
    fabs(refraction.theta - 0.0) < 1e-6,
    "CapyGetRefraction failed");
}

CUTEST(test009, "Refraction values water/air (2)") {
  CapyRefractionValue refraction = CapyGetRefraction(
    capyRefractiveCoeffs[capyMaterialIdx_water],
    capyRefractiveCoeffs[capyMaterialIdx_air],
    0.1);
  CUTEST_ASSERT(
    fabs(refraction.reflective - 0.020332) < 1e-6 &&
    fabs(refraction.transmissive - 0.979668) < 1e-6 &&
    fabs(refraction.theta - 0.133435) < 1e-6,
    "CapyGetRefraction failed");
}
