#include "capy.h"
#ifndef FIXTURE
#define FIXTURE

// Dummy structure
typedef struct Dummy {
  int a;
  CapyPad(int, 0);
  double b;
} Dummy;

CapyDecList(CapyListDummy, Dummy)
CapyDefList(CapyListDummy, Dummy)
static int DummyCmp(
  void const* a,
  void const* b) {
  if(((Dummy*)a)->a > ((Dummy*)b)->a) return 1;
  else if(((Dummy*)a)->a < ((Dummy*)b)->a) return -1;
  else return 0;
}

#endif
CUTEST(test001, "Generic list operations") {
  Dummy dummies[3] = {
    (Dummy){.a = 0, .b = 1.0},
    (Dummy){.a = 1, .b = 2.0},
    (Dummy){.a = 2, .b = 3.0},
  };
  CapyListDummy list = CapyListDummyCreate();
  size_t size = $(&list, getSize)();
  CUTEST_ASSERT(size == 0, "unexpected size %lu", size);
  CUTEST_ASSERT($(&list, isEmpty)(), "isEmpty failed");
  $(&list, push)(dummies[0]);
  size = $(&list, getSize)();
  CUTEST_ASSERT(size == 1, "unexpected size %lu", size);
  CUTEST_ASSERT($(&list, isEmpty)() == false, "isEmpty failed");
  Dummy dummy = $(&list, get)(0);
  CUTEST_ASSERT(
    dummy.a == dummies[0].a &&
    equal(dummy.b, dummies[0].b),
    "get failed %d != %d %lf != %lf",
    dummy.a, dummies[0].a, dummy.b, dummies[0].b);
  $(&list, push)(dummies[1]);
  size = $(&list, getSize)();
  CUTEST_ASSERT(size == 2, "unexpected size %lu", size);
  $(&list, push)(dummies[2]);
  size = $(&list, getSize)();
  CUTEST_ASSERT(size == 3, "unexpected size %lu", size);
  loop(i, (size_t)3) {
    dummy = $(&list, get)(2 - i);
    CUTEST_ASSERT(
      dummy.a == dummies[i].a &&
      equal(dummy.b, dummies[i].b),
      "get failed %d != %d %lf != %lf",
      dummy.a, dummies[i].a, dummy.b, dummies[i].b);
    dummy = *$(&list, getPtr)(2 - i);
    CUTEST_ASSERT(
      dummy.a == dummies[i].a &&
      equal(dummy.b, dummies[i].b),
      "getPtr failed %d != %d %lf != %lf",
      dummy.a, dummies[i].a, dummy.b, dummies[i].b);
  }
  dummy = $(&list, getHead)();
  CUTEST_ASSERT(
    dummy.a == dummies[2].a &&
    equal(dummy.b, dummies[2].b),
    "getHead failed %d != %d %lf != %lf",
    dummy.a, dummies[2].a, dummy.b, dummies[2].b);
  dummy = $(&list, getTail)();
  CUTEST_ASSERT(
    dummy.a == dummies[0].a &&
    equal(dummy.b, dummies[0].b),
    "getTail failed %d != %d %lf != %lf",
    dummy.a, dummies[0].a, dummy.b, dummies[0].b);
  dummy = *$(&list, getPtrHead)();
  CUTEST_ASSERT(
    dummy.a == dummies[2].a &&
    equal(dummy.b, dummies[2].b),
    "getPtrHead failed %d != %d %lf != %lf",
    dummy.a, dummies[2].a, dummy.b, dummies[2].b);
  dummy = *$(&list, getPtrTail)();
  CUTEST_ASSERT(
    dummy.a == dummies[0].a &&
    equal(dummy.b, dummies[0].b),
    "getPtrTail failed %d != %d %lf != %lf",
    dummy.a, dummies[0].a, dummy.b, dummies[0].b);
  $(&list, flush)();
  size = $(&list, getSize)();
  CUTEST_ASSERT(size == 0, "unexpected size %lu", size);
  loop(i, 3) $(&list, push)(dummies[i]);
  loop(i, 3) {
    dummy = $(&list, pop)();
    size = $(&list, getSize)();
    CUTEST_ASSERT(size == (size_t)(2 - i), "unexpected size %lu", size);
    CUTEST_ASSERT(
      dummy.a == dummies[2 - i].a &&
      equal(dummy.b, dummies[2 - i].b),
      "pop failed %d != %d %lf != %lf",
      dummy.a, dummies[2 - i].a, dummy.b, dummies[2 - i].b);
  }
  loop(i, 3) $(&list, add)(dummies[i]);
  loop(i, (size_t)3) {
    dummy = $(&list, get)(i);
    CUTEST_ASSERT(
      dummy.a == dummies[i].a &&
      equal(dummy.b, dummies[i].b),
      "add failed %d != %d %lf != %lf",
      dummy.a, dummies[i].a, dummy.b, dummies[i].b);
  }
  loop(i, 3) {
    dummy = $(&list, drop)();
    size = $(&list, getSize)();
    CUTEST_ASSERT(size == (size_t)(2 - i), "unexpected size %lu", size);
    CUTEST_ASSERT(
      dummy.a == dummies[2 - i].a &&
      equal(dummy.b, dummies[2 - i].b),
      "drop failed %d != %d %lf != %lf",
      dummy.a, dummies[2 - i].a, dummy.b, dummies[2 - i].b);
  }
  $(&list, destruct)();
  CapyListDummy* listPtr = CapyListDummyAlloc();
  loop(i, 3) $(listPtr, add)(dummies[i]);
  $(&(listPtr->iter), setType)(capyListIteratorType_backward);
  forEach(d, listPtr->iter) {
    CUTEST_ASSERT(
      d.a == (int)(2 - listPtr->iter.idx), "iterator failed %d", d.a);
    if(listPtr->iter.idx == 0) {
      CUTEST_ASSERT($(&(listPtr->iter), isFirst)(), "isFirst failed");
    }
    if(listPtr->iter.idx == 0) {
      CUTEST_ASSERT(!$(&(listPtr->iter), isLast)(), "isLast failed");
    }
    if(listPtr->iter.idx == 2) {
      CUTEST_ASSERT(!$(&(listPtr->iter), isFirst)(), "iFirst failed");
    }
    if(listPtr->iter.idx == 2) {
      CUTEST_ASSERT($(&(listPtr->iter), isLast)(), "isLast failed");
    }
  }
  CapyListDummyFree(&listPtr);
  CUTEST_ASSERT(listPtr == NULL, "listPtr not reset");
}

CUTEST(test002, "Insert sort") {
  Dummy dummies[5] = {
    (Dummy){.a = 1, .b = 1.0},
    (Dummy){.a = 0, .b = 0.0},
    (Dummy){.a = 4, .b = 4.0},
    (Dummy){.a = 2, .b = 2.0},
    (Dummy){.a = 3, .b = 3.0},
  };
  CapyListDummy list = CapyListDummyCreate();
  CapyComparator cmp = { .eval = DummyCmp };
  loop(i, 5) $(&list, insertSort)(&cmp, dummies[i]);
  bool isOk = true;
  $(&list, initIterator)();
  forEach(d, list.iter) {
    isOk &= (d.a == (int)(list.iter.idx));
  }
  CUTEST_ASSERT(isOk, "insertSort failed");
  $(&list, destruct)();
}
