#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Create a maze and free it") {
  CapyMaze2D* maze = CapyMaze2DAlloc(20, 10);
  CapyMaze2D* ptr = maze;
  CapyMaze2DFree(&maze);
  CUTEST_ASSERT(
    maze == NULL && ptr != NULL,
    "maze=%p, ptr=%p", (void*)maze, (void*)ptr);
}

CUTEST(test002, "Generate a maze using origin shift") {
  CapyMaze2D* maze = CapyMaze2DAlloc(40, 30);
  CapyRandom* rng = CapyRandomAlloc(1);
  $(maze, generateByOriginShift)(rng);
  CapyImgDims dims = {.width = 410, .height = 310};
  CapyImg* img = CapyImgAlloc(capyImgMode_rgba, dims);
  $(img, fillWithColor)(&capyColorRGBAWhite);
  CapyPen pen = CapyPenCreate();
  pen.color = capyColorRGBABlack;
  CapyImgDims mazeDims = {.width = 400, .height = 300};
  CapyImgPos pos = {.x = 5, .y = 5};
  $(maze, draw)(img, &pen, mazeDims, pos);
  $(img, saveToPath)("UnitTests/TestMaze/maze.png");
  CapyImg* checkImg = CapyImgLoadFromPath(
    "UnitTests/TestMaze/checkMaze.png");
  CUTEST_ASSERT(
    $(img, isSame)(checkImg),
    "maze generation failed");
  $(&pen, destruct)();
  CapyImgFree(&img);
  CapyImgFree(&checkImg);
  CapyMaze2DFree(&maze);
  CapyRandomFree(&rng);
}
