#include "capy.h"
#ifndef FIXTURE
#define FIXTURE

// Dummy structure
typedef struct Data Data;
struct Data{
  double x;
  CapyMemPoolFields(Data);
  void (*destruct)(void);
};

CapyDecMemPool(CapyMemPoolData, Data)
CapyDefMemPool(CapyMemPoolData, Data)
#define NB_LOOP 100
#define N 10
#define NB_TRY 100
static uint64_t TestMalloc(void) {
  uint16_t arr[N];
  loop(i, N) arr[i] = 0;
  arr[0] = 1;
  uint64_t garbage = 0;
  loop(iLoop, NB_LOOP) {
    loop(i, N - 1) arr[N - 1 - i] += arr[N - 2 - i];
    loop(i, N) loop(j, arr[i]) {
      Data* data = malloc(sizeof(Data));
      garbage += (uint64_t)data;
      free(data);
    }
  }
  return garbage;
}

static uint64_t TestMemPool(void) {
  uint16_t arr[N];
  loop(i, N) arr[i] = 0;
  arr[0] = 1;
  CapyMemPoolData* memPool = CapyMemPoolDataAlloc(sizeof(Data));
  uint64_t garbage = 0;
  loop(iLoop, NB_LOOP) {
    loop(i, N - 1) arr[N - 1 - i] += arr[N - 2 - i];
    loop(i, N) loop(j, arr[i]) {
      Data* data = $(memPool, alloc)(NULL);
      garbage += (uint64_t)data;
      $(memPool, free)(&data);
    }
  }
  CapyMemPoolDataFree(&memPool);
  return garbage;
}

#endif
CUTEST(test001, "MemPool speed comparison when reusing one element only") {
  double avg[2] = {0.0, 0.0};
  double sigma[2] = {0.0, 0.0};
  uint64_t (*testFun[2])(void) = {TestMalloc, TestMemPool};
  uint64_t garbage;
  loop(iTest, 2) {
    CapyChrono chrono = CapyChronoCreate();
    double delay[NB_TRY];
    loop(i, NB_TRY) {
      $(&chrono, start)();
      garbage += testFun[iTest]();
      $(&chrono, stop)();
      delay[i] = $(&chrono, getElapsedTime)(capyChrono_second);
    }
    loop(i, NB_TRY) avg[iTest] += delay[i] / (double)NB_TRY;
    loop(i, NB_TRY) {
      sigma[iTest] += pow(delay[i] - avg[iTest], 2.0) / (double)NB_TRY;
    }
  }
  CUTEST_ASSERT(
    avg[0] - sigma[0] > avg[1] + sigma[1],
    "MemPool slower than malloc %lf <= %lf",
    avg[0] - sigma[0], avg[1] + sigma[1]);
}

CUTEST(test002, "MemPool operations (1)") {
  CapyMemPoolData* memPool = CapyMemPoolDataAlloc(sizeof(Data));
  Data* data[3];
  loop(i, 3) data[i] = $(memPool, alloc)(NULL);
  (void)data;
  CUTEST_ASSERT(
    memPool->size == 3 && memPool->nbUsed == 3,
    "memPool->size=%lu != 3 && memPool->nbUsed=%lu != 3",
    memPool->size, memPool->nbUsed);
  CapyMemPoolDataFree(&memPool);
}

CUTEST(test003, "MemPool operations (2)") {
  CapyMemPoolData* memPool = CapyMemPoolDataAlloc(sizeof(Data));
  Data* data[3];
  loop(i, 3) data[i] = $(memPool, alloc)(NULL);
  loop(i, 3) $(memPool, free)(data + i);
  CUTEST_ASSERT(
    memPool->size == 3 && memPool->nbUsed == 0,
    "memPool->size=%lu != 3 && memPool->nbUsed=%lu != 0",
    memPool->size, memPool->nbUsed);
  CapyMemPoolDataFree(&memPool);
}

CUTEST(test004, "MemPool operations (3)") {
  CapyMemPoolData* memPool = CapyMemPoolDataAlloc(sizeof(Data));
  Data* data[3];
  Data* dataBack[3];
  loop(i, 3) dataBack[i] = data[i] = $(memPool, alloc)(NULL);
  loop(i, 3) $(memPool, free)(data + i);
  loop(i, 3) data[i] = $(memPool, alloc)(NULL);
  CUTEST_ASSERT(
    memPool->size == 3 && memPool->nbUsed == 3 &&
    data[0] == dataBack[2] && data[1] == dataBack[1] && data[2] == dataBack[0],
    "memPool->size=%lu != 3 && memPool->nbUsed=%lu != 3 && "
    "data=[%p, %p, %p] != [%p, %p, %p]",
    memPool->size, memPool->nbUsed,
    (void*)(data[0]), (void*)(data[1]), (void*)(data[2]),
    (void*)(dataBack[2]), (void*)(dataBack[1]), (void*)(dataBack[0]));
  CapyMemPoolDataFree(&memPool);
}

CUTEST(test005, "MemPool operations (4)") {
  CapyMemPoolData* memPool = CapyMemPoolDataAlloc(sizeof(Data));
  Data* data[3];
  Data* dataBack[3];
  loop(i, 3) dataBack[i] = data[i] = $(memPool, alloc)(NULL);
  loop(i, 3) $(memPool, free)(data + 2 - i);
  loop(i, 3) data[i] = $(memPool, alloc)(NULL);
  CUTEST_ASSERT(
    memPool->size == 3 && memPool->nbUsed == 3 &&
    data[0] == dataBack[0] && data[1] == dataBack[1] && data[2] == dataBack[2],
    "memPool->size=%lu != 3 && memPool->nbUsed=%lu != 3 && "
    "data=[%p, %p, %p] != [%p, %p, %p]",
    memPool->size, memPool->nbUsed,
    (void*)(data[0]), (void*)(data[1]), (void*)(data[2]),
    (void*)(dataBack[0]), (void*)(dataBack[1]), (void*)(dataBack[2]));
  CapyMemPoolDataFree(&memPool);
}

