#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Direction to image position (1)") {
  char const* const pathImg = "./UnitTests/TestMirrorBallCamera/glassball.png";
  CapyImg* img = CapyImgLoadFromPath(pathImg);
  CapyMirrorBallCamera* mbc = CapyMirrorBallCameraAlloc(img);
  double const y[3] = {0, 1, 0};
  CapyQuaternion quat = CapyQuaternionCreateFromRotAxis(y, M_PI / 10.0);
  bool isOk = true;
  CapyImgPos_t check[10][2] = {
    {799, 402},
    {784, 402},
    {760, 402},
    {727, 402},
    {686, 402},
    {638, 402},
    {584, 402},
    {526, 402},
    {464, 402},
    {402, 402},
  };
  loop(i, 10) {
    $(mbc->camera, rotate)(&quat);
    CapyImgPos pos = $(mbc, fromViewDirectionToImgPos)(mbc->camera->front.vals);
    isOk &= (pos.x == check[i][0]) && (pos.y == check[i][1]);
  }
  CUTEST_ASSERT(isOk, "fromViewDirectionToImgPos failed");
  CapyMirrorBallCameraFree(&mbc);
  $(&quat, destruct)();
}

CUTEST(test002, "Direction to image position (2)") {
  char const* const pathImg = "./UnitTests/TestMirrorBallCamera/glassball.png";
  CapyImg* img = CapyImgLoadFromPath(pathImg);
  CapyMirrorBallCamera* mbc = CapyMirrorBallCameraAlloc(img);
  double const x[3] = {1, 0, 0};
  CapyQuaternion quat = CapyQuaternionCreateFromRotAxis(x, M_PI / 10.0);
  bool isOk = true;
  CapyImgPos_t check[10][2] = {
    {402, 799},
    {402, 784},
    {402, 760},
    {402, 727},
    {402, 686},
    {402, 638},
    {402, 584},
    {402, 526},
    {402, 464},
    {402, 402},
  };
  loop(i, 10) {
    $(mbc->camera, rotate)(&quat);
    CapyImgPos pos = $(mbc, fromViewDirectionToImgPos)(mbc->camera->front.vals);
    isOk &= (pos.x == check[i][0]) && (pos.y == check[i][1]);
  }
  CUTEST_ASSERT(isOk, "fromViewDirectionToImgPos failed");
  CapyMirrorBallCameraFree(&mbc);
  $(&quat, destruct)();
}

CUTEST(test003, "Render (1)") {
  char const* const pathImg = "./UnitTests/TestMirrorBallCamera/glassball.png";
  CapyImg* img = CapyImgLoadFromPath(pathImg);
  CapyMirrorBallCamera* mbc = CapyMirrorBallCameraAlloc(img);
  mbc->alpha = M_PI_4;
  mbc->camera->focalLength *= 0.25;
  double const y[3] = {0, 1, 0};
  CapyQuaternion quat = CapyQuaternionCreateFromRotAxis(y, M_PI);
  $(mbc->camera, rotate)(&quat);
  CapyImgDims const dims = capyImgDims_800x600;
  CapyImg* res = $(mbc, render)(dims);
  CapyImg* checkImg = CapyImgLoadFromPath(
    "./UnitTests/TestMirrorBallCamera/check01.png");
  CUTEST_ASSERT($(res, isSame)(checkImg), "render failed");
  CapyImgFree(&checkImg);
  CapyMirrorBallCameraFree(&mbc);
  CapyImgFree(&res);
  $(&quat, destruct)();
}

CUTEST(test004, "Render (2)") {
  char const* const pathImg = "./UnitTests/TestMirrorBallCamera/glassball.png";
  CapyImg* img = CapyImgLoadFromPath(pathImg);
  CapyMirrorBallCamera* mbc = CapyMirrorBallCameraAlloc(img);
  mbc->alpha = M_PI_4;
  mbc->camera->focalLength *= 0.25;
  double const y[3] = {0, 1, 0};
  CapyQuaternion quat = CapyQuaternionCreateFromRotAxis(y, M_PI + M_PI_4);
  $(mbc->camera, rotate)(&quat);
  CapyImgDims const dims = capyImgDims_800x600;
  CapyImg* res = $(mbc, render)(dims);
  CapyImg* checkImg = CapyImgLoadFromPath(
    "./UnitTests/TestMirrorBallCamera/check02.png");
  CUTEST_ASSERT($(res, isSame)(checkImg), "render failed");
  CapyImgFree(&checkImg);
  CapyMirrorBallCameraFree(&mbc);
  CapyImgFree(&res);
  $(&quat, destruct)();
}

CUTEST(test005, "Render (3)") {
  char const* const pathImg = "./UnitTests/TestMirrorBallCamera/glassball.png";
  CapyImg* img = CapyImgLoadFromPath(pathImg);
  CapyMirrorBallCamera* mbc = CapyMirrorBallCameraAlloc(img);
  mbc->alpha = M_PI_4;
  mbc->camera->focalLength *= 0.25;
  double const y[3] = {0, 1, 0};
  CapyQuaternion quat = CapyQuaternionCreateFromRotAxis(y, M_PI + M_PI_2);
  $(mbc->camera, rotate)(&quat);
  CapyImgDims const dims = capyImgDims_800x600;
  CapyImg* res = $(mbc, render)(dims);
  CapyImg* checkImg = CapyImgLoadFromPath(
    "./UnitTests/TestMirrorBallCamera/check03.png");
  CUTEST_ASSERT($(res, isSame)(checkImg), "render failed");
  CapyImgFree(&checkImg);
  CapyMirrorBallCameraFree(&mbc);
  CapyImgFree(&res);
  $(&quat, destruct)();
}

