#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "create fully connected") {
  CapyNNActivationSiLU silu = CapyNNActivationSiLUCreate();
  CapyNNActivationReLU relu = CapyNNActivationReLUCreate();
  CapyNNModel layerDef = {
    .nbLayer = 2,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 3, .activation = (CapyNNActivationFun*)&silu},
      {.nbNode = 5, .activation = (CapyNNActivationFun*)&relu}
    },
  };
  CapyNeuralNetwork* nn = CapyNeuralNetworkAllocFullyConnected(1, &layerDef, 6);
  CUTEST_ASSERT(
    nn->nbInput == 1 && nn->nbOutput == 6 && nn->nbLayer == 4,
    "create failed, nbInput=%lu != 1, nbOutput=%lu != 6, nbLayer=%lu != 4",
    nn->nbInput, nn->nbOutput, nn->nbLayer);
  CUTEST_ASSERT(
    nn->layers[0].nbNode == 1,
    "create failed, nbNode[0]=%lu != 1", nn->layers[0].nbNode);
  CUTEST_ASSERT(
    nn->layers[1].nbNode == 3,
    "create failed, nbNode[1]=%lu != 3", nn->layers[1].nbNode);
  CUTEST_ASSERT(
    nn->layers[2].nbNode == 5,
    "create failed, nbNode[2]=%lu != 5", nn->layers[2].nbNode);
  CUTEST_ASSERT(
    nn->layers[3].nbNode == 6,
    "create failed, nbNode[3]=%lu != 6", nn->layers[3].nbNode);
  CapyNeuralNetworkFree(&nn);
  layerDef.layers[1].nbNode = 1;
  nn = CapyNeuralNetworkAllocFullyConnected(2, &layerDef, 2);
  loop(i, 2) {
    CUTEST_ASSERT(
      nn->layers[0].nodes[i].nbLink == 0,
      "create failed, nbLink[0,%d]=%lu != 0",
      i, nn->layers[0].nodes[i].nbLink);
  }
  loop(i, (size_t)3) loop(j, nn->layers[i + 1].nbNode) {
    CUTEST_ASSERT(
      nn->layers[i + 1].nodes[j].nbLink == nn->layers[i].nbNode,
      "create failed, nbLink[%lu,%lu]=%lu != %lu",
      i, j, nn->layers[i + 1].nodes[j].nbLink, nn->layers[i].nbNode);
    loop(k, nn->layers[i].nbNode) {
      CUTEST_ASSERT(
        nn->layers[i + 1].nodes[j].links[k].iNode == k,
        "create failed, iNode[%lu,%lu,%lu]=%lu != %lu",
        i, j, k, nn->layers[i + 1].nodes[j].links[k].iNode, k);
      CUTEST_ASSERT(
        nn->layers[i + 1].nodes[j].links[k].iLayer == i,
        "create failed, iLayer[%lu,%lu,%lu]=%lu != %lu",
        i, j, k, nn->layers[i + 1].nodes[j].links[k].iLayer, i);
    }
  }
  CapyNeuralNetworkFree(&nn);
  $(&silu, destruct)();
  $(&relu, destruct)();
}

CUTEST(test002, "eval") {
  CapyNNActivationSigmoid sigmoid = CapyNNActivationSigmoidCreate();
  CapyNNModel layerDef = {
    .nbLayer = 1,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 2, .activation = (CapyNNActivationFun*)&sigmoid}
    },
  };
  CapyNeuralNetwork* nn = CapyNeuralNetworkAllocFullyConnected(2, &layerDef, 1);
  nn->params[nn->layers[1].nodes[0].idxBias] = -1.0;
  nn->params[nn->layers[1].nodes[0].links[0].idxWeight] = 1.0;
  nn->params[nn->layers[1].nodes[0].links[1].idxWeight] = 2.0;
  nn->params[nn->layers[1].nodes[1].idxBias] = -2.0;
  nn->params[nn->layers[1].nodes[1].links[0].idxWeight] = 3.0;
  nn->params[nn->layers[1].nodes[1].links[1].idxWeight] = 4.0;
  nn->params[nn->layers[2].nodes[0].idxBias] = -3.0;
  nn->params[nn->layers[2].nodes[0].links[0].idxWeight] = 5.0;
  nn->params[nn->layers[2].nodes[0].links[1].idxWeight] = 6.0;
  double in[2] = {0.1, 0.2};
  double out;
  $(nn, eval)(in, &out);
  CUTEST_ASSERT(
    fabs(nn->layers[1].nodes[0].val - 0.37754066) < 0.00001,
    "unexpected node value %lf", nn->layers[1].nodes[0].val);
  CUTEST_ASSERT(
    fabs(nn->layers[1].nodes[1].val - 0.28905049) < 0.00001,
    "unexpected node value %lf", nn->layers[1].nodes[1].val);
  CUTEST_ASSERT(
    fabs(nn->layers[2].nodes[0].val - 0.622006) < 0.00001,
    "unexpected node value %lf", nn->layers[2].nodes[0].val);
  CUTEST_ASSERT(
    fabs(out - 0.622006) < 0.00001,
    "unexpected out value %lf", out);
  CapyNeuralNetworkFree(&nn);
  $(&sigmoid, destruct)();
}

CUTEST(test003, "eval recurrent") {
  CapyNNActivationLinear linear = CapyNNActivationLinearCreate();
  CapyNNModel layerDef = {
    .nbLayer = 1,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 1, .activation = (CapyNNActivationFun*)&linear}
    }
  };
  CapyNeuralNetwork* nn = CapyNeuralNetworkAllocFullyConnected(2, &layerDef, 1);
  nn->params[nn->layers[1].nodes[0].idxBias] = 1.0;
  nn->params[nn->layers[1].nodes[0].links[0].idxWeight] = 2.0;
  nn->params[nn->layers[1].nodes[0].links[1].idxWeight] = 3.0;
  nn->params[nn->layers[2].nodes[0].links[0].idxWeight] = 1.0;
  nn->layers[1].nodes[0].links[1].iNode = 0;
  nn->layers[1].nodes[0].links[1].iLayer = 1;
  double in[2] = {0.1, 0.0};
  double out;
  $(nn, eval)(in, &out);
  CUTEST_ASSERT(
    fabs(out - 1.2) < 0.00001,
    "unexpected out value %lf", out);
  $(nn, eval)(in, &out);
  CUTEST_ASSERT(
    fabs(out - 4.8) < 0.00001,
    "unexpected out value %lf", out);
  CapyNeuralNetworkFree(&nn);
  $(&linear, destruct)();
}

