#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "iris dataset") {
  CapyDataset* dataset = CapyDatasetAlloc();
  char const* pathDataset = "Resources/iris.csv";
  $(dataset, loadFromPath)(pathDataset);
  CapyNNActivationSiLU silu = CapyNNActivationSiLUCreate();
  CapyNNModel layerDef = {
    .nbLayer = 1,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 8, .activation = (CapyNNActivationFun*)&silu},
    },
  };
  CapyNNPredictor* predictor =
    CapyNNPredictorAlloc(&layerDef, capyPredictorType_categorical);
  predictor->verbose = false;
  predictor->timeTraining = 0.0;
  predictor->nbIterTrainMax = 100;
  predictor->seed = 2;
  predictor->batchSize = 150;
  predictor->featureScaling = capyPredictorFeatureScaling_minMaxNormalization;
  $(predictor, train)(dataset);
  CapyPredictorEvaluation* eval = $(predictor, evaluate)(dataset);
  CUTEST_ASSERT(
    fabs(eval->accuracies[capyPredictorAccuracyMeasure_accuracy] - 0.98) < 1e-4,
    "train failed %lf",
    eval->accuracies[capyPredictorAccuracyMeasure_accuracy]);
  FILE* stream = fopen("UnitTests/TestNNPredictor/iris.c", "w");
  $(predictor, exportToCFun)(stream, "IrisPred", dataset);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestNNPredictor/iris.c "
      "UnitTests/TestNNPredictor/iris_check.c >"
      "UnitTests/TestNNPredictor/iris_diff.txt") == 0,
    "exportToCFun failed");
  stream = fopen("UnitTests/TestNNPredictor/iris.html", "w");
  $(predictor, exportToHtml)(
    stream, "Iris species prediction",
    dataset, eval->accuracies[capyPredictorAccuracyMeasure_accuracy]);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestNNPredictor/iris.html "
      "UnitTests/TestNNPredictor/iris_check.html >"
      "UnitTests/TestNNPredictor/iris_diff.txt") == 0,
    "exportToCFun failed");
  CapyNNPredictorFree(&predictor);
  CapyPredictorEvaluationFree(&eval);
  $(&silu, destruct)();
  CapyDatasetFree(&dataset);
}

CUTEST(test002, "test001.csv") {
  CapyDataset* dataset = CapyDatasetAlloc();
  char const* pathDataset =
    "UnitTests/TestNNPredictor/test001.csv";
  $(dataset, loadFromPath)(pathDataset);
  CapyNNActivationSigmoid sigmoid = CapyNNActivationSigmoidCreate();
  CapyNNModel layerDef = {
    .nbLayer = 1,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 2, .activation = (CapyNNActivationFun*)&sigmoid},
    },
  };
  CapyNNPredictor* predictor =
    CapyNNPredictorAlloc(&layerDef, capyPredictorType_categorical);
  predictor->verbose = false;
  predictor->timeTraining = 0.0;
  predictor->nbIterTrainMax = 100;
  predictor->seed = 12345;
  predictor->batchSize = 2;
  predictor->featureScaling = capyPredictorFeatureScaling_minMaxNormalization;
  $(predictor, train)(dataset);
  CapyPredictorEvaluation* eval = $(predictor, evaluate)(dataset);
  CUTEST_ASSERT(
    fabs(eval->accuracies[capyPredictorAccuracyMeasure_accuracy] - 0.95) < 1e-4,
    "train failed %lf",
    eval->accuracies[capyPredictorAccuracyMeasure_accuracy]);
  CapyNNPredictorFree(&predictor);
  CapyPredictorEvaluationFree(&eval);
  $(&sigmoid, destruct)();
  CapyDatasetFree(&dataset);
}

CUTEST(test003, "abalone dataset (minMaxNormalizationSym)") {
  CapyDataset* dataset = CapyDatasetAlloc();
  char const* pathDataset = "Resources/abalone.csv";
  $(dataset, loadFromPath)(pathDataset);
  CapyNNActivationReLU relu = CapyNNActivationReLUCreate();
  CapyNNModel layerDef = {
    .nbLayer = 2,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 16, .activation = (CapyNNActivationFun*)&relu},
      {.nbNode = 8, .activation = (CapyNNActivationFun*)&relu},
    },
  };
  CapyNNPredictor* predictor =
    CapyNNPredictorAlloc(&layerDef, capyPredictorType_numerical);
  predictor->verbose = false;
  predictor->featureScaling =
    capyPredictorFeatureScaling_minMaxNormalizationSym;
  predictor->timeTraining = 0.0;
  predictor->nbIterTrainMax = 100;
  predictor->seed = 2;
  predictor->batchSize = 1000;
  $(predictor, train)(dataset);
  CapyPredictorEvaluation* eval = $(predictor, evaluate)(dataset);
  CUTEST_ASSERT(
    fabs(eval->accuracies[capyPredictorAccuracyMeasure_mae] - 1.7563) < 1e-4,
    "train failed %lf", eval->accuracies[capyPredictorAccuracyMeasure_mae]);
  FILE* stream = fopen("UnitTests/TestNNPredictor/abalone.c", "w");
  $(predictor, exportToCFun)(stream, "abalonePred", dataset);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestNNPredictor/abalone.c "
      "UnitTests/TestNNPredictor/abalone_check.c >"
      "UnitTests/TestNNPredictor/abalone_diff.txt") == 0,
    "exportToCFun failed");
  stream = fopen("UnitTests/TestNNPredictor/abalone.html", "w");
  $(predictor, exportToHtml)(
    stream, "Abalone age prediction",
    dataset, eval->accuracies[capyPredictorAccuracyMeasure_mae]);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestNNPredictor/abalone.html "
      "UnitTests/TestNNPredictor/abalone_check.html >"
      "UnitTests/TestNNPredictor/abalone_diff.txt") == 0,
    "exportToCFun failed");
  CapyNNPredictorFree(&predictor);
  CapyPredictorEvaluationFree(&eval);
  $(&relu, destruct)();
  CapyDatasetFree(&dataset);
}

CUTEST(test004, "abalone dataset (minMaxNormalization)") {
  CapyDataset* dataset = CapyDatasetAlloc();
  char const* pathDataset = "Resources/abalone.csv";
  $(dataset, loadFromPath)(pathDataset);
  CapyNNActivationReLU relu = CapyNNActivationReLUCreate();
  CapyNNModel layerDef = {
    .nbLayer = 2,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 16, .activation = (CapyNNActivationFun*)&relu},
      {.nbNode = 8, .activation = (CapyNNActivationFun*)&relu},
    },
  };
  CapyNNPredictor* predictor =
    CapyNNPredictorAlloc(&layerDef, capyPredictorType_numerical);
  predictor->verbose = false;
  predictor->featureScaling = capyPredictorFeatureScaling_minMaxNormalization;
  predictor->timeTraining = 0.0;
  predictor->nbIterTrainMax = 100;
  predictor->seed = 2;
  predictor->batchSize = 1000;
  $(predictor, train)(dataset);
  CapyPredictorEvaluation* eval = $(predictor, evaluate)(dataset);
  CUTEST_ASSERT(
    fabs(eval->accuracies[capyPredictorAccuracyMeasure_mae] - 1.8762) < 1e-4,
    "train failed %lf", eval->accuracies[capyPredictorAccuracyMeasure_mae]);
  CapyNNPredictorFree(&predictor);
  CapyPredictorEvaluationFree(&eval);
  $(&relu, destruct)();
  CapyDatasetFree(&dataset);
}

CUTEST(test005, "abalone dataset (meanNormalization)") {
  CapyDataset* dataset = CapyDatasetAlloc();
  char const* pathDataset = "Resources/abalone.csv";
  $(dataset, loadFromPath)(pathDataset);
  CapyNNActivationReLU relu = CapyNNActivationReLUCreate();
  CapyNNModel layerDef = {
    .nbLayer = 2,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 16, .activation = (CapyNNActivationFun*)&relu},
      {.nbNode = 8, .activation = (CapyNNActivationFun*)&relu},
    },
  };
  CapyNNPredictor* predictor =
    CapyNNPredictorAlloc(&layerDef, capyPredictorType_numerical);
  predictor->verbose = false;
  predictor->featureScaling = capyPredictorFeatureScaling_meanNormalization;
  predictor->timeTraining = 0.0;
  predictor->nbIterTrainMax = 100;
  predictor->seed = 2;
  predictor->batchSize = 1000;
  $(predictor, train)(dataset);
  CapyPredictorEvaluation* eval = $(predictor, evaluate)(dataset);
  CUTEST_ASSERT(
    fabs(eval->accuracies[capyPredictorAccuracyMeasure_mae] - 1.5981) < 1e-4,
    "train failed %lf", eval->accuracies[capyPredictorAccuracyMeasure_mae]);
  CapyNNPredictorFree(&predictor);
  CapyPredictorEvaluationFree(&eval);
  $(&relu, destruct)();
  CapyDatasetFree(&dataset);
}

CUTEST(test006, "abalone dataset (standardization)") {
  CapyDataset* dataset = CapyDatasetAlloc();
  char const* pathDataset = "Resources/abalone.csv";
  $(dataset, loadFromPath)(pathDataset);
  CapyNNActivationReLU relu = CapyNNActivationReLUCreate();
  CapyNNModel layerDef = {
    .nbLayer = 2,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 16, .activation = (CapyNNActivationFun*)&relu},
      {.nbNode = 8, .activation = (CapyNNActivationFun*)&relu},
    },
  };
  CapyNNPredictor* predictor =
    CapyNNPredictorAlloc(&layerDef, capyPredictorType_numerical);
  predictor->verbose = false;
  predictor->featureScaling = capyPredictorFeatureScaling_standardization;
  predictor->timeTraining = 0.0;
  predictor->nbIterTrainMax = 100;
  predictor->seed = 2;
  predictor->batchSize = 1000;
  $(predictor, train)(dataset);
  CapyPredictorEvaluation* eval = $(predictor, evaluate)(dataset);
  CUTEST_ASSERT(
    fabs(eval->accuracies[capyPredictorAccuracyMeasure_mae] - 1.5339) < 1e-4,
    "train failed %lf", eval->accuracies[capyPredictorAccuracyMeasure_mae]);
  CapyNNPredictorFree(&predictor);
  CapyPredictorEvaluationFree(&eval);
  $(&relu, destruct)();
  CapyDatasetFree(&dataset);
}

CUTEST(test007, "load/save") {
  CapyDataset* dataset = CapyDatasetAlloc();
  char const* pathDataset = "Resources/iris.csv";
  $(dataset, loadFromPath)(pathDataset);
  CapyNNActivationSiLU silu = CapyNNActivationSiLUCreate();
  CapyNNModel layerDef = {
    .nbLayer = 1,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 8, .activation = (CapyNNActivationFun*)&silu},
    },
  };
  CapyNNPredictor* predictor =
    CapyNNPredictorAlloc(&layerDef, capyPredictorType_categorical);
  predictor->verbose = false;
  predictor->timeTraining = 0.0;
  predictor->nbIterTrainMax = 100;
  predictor->seed = 2;
  predictor->batchSize = 150;
  predictor->featureScaling = capyPredictorFeatureScaling_minMaxNormalization;
  CapyNNPredictorFree(&predictor);
  FILE* fp = fopen("UnitTests/TestNNPredictor/iris.nn", "rb");
  predictor = CapyNNPredictorLoad(fp);
  fclose(fp);
  CapyPredictorEvaluation* eval = $(predictor, evaluate)(dataset);
  CUTEST_ASSERT(
    fabs(
      eval->accuracies[capyPredictorAccuracyMeasure_accuracy] - 0.98666) < 1e-4,
    "load/save failed %lf",
    eval->accuracies[capyPredictorAccuracyMeasure_accuracy]);
  CapyNNPredictorFree(&predictor);
  CapyPredictorEvaluationFree(&eval);
  $(&silu, destruct)();
  CapyDatasetFree(&dataset);
}

CUTEST(test008, "studying hour dataset (logistic regression)") {
  CapyDataset* dataset = CapyDatasetAlloc();
  char const* pathDataset = "UnitTests/TestNNPredictor/test002.csv";
  $(dataset, loadFromPath)(pathDataset);
  CapyNNActivationSigmoid sigmoid = CapyNNActivationSigmoidCreate();
  CapyNNModel layerDef = {
    .nbLayer = 1,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 1, .activation = (CapyNNActivationFun*)&sigmoid},
    },
  };
  CapyNNPredictor* predictor =
    CapyNNPredictorAlloc(&layerDef, capyPredictorType_categorical);
  predictor->verbose = false;
  predictor->featureScaling = capyPredictorFeatureScaling_meanNormalization;
  predictor->timeTraining = 0.0;
  predictor->nbIterTrainMax = 100;
  predictor->seed = 2;
  predictor->batchSize = 1000;
  predictor->lossType = capyNNPredictorLossType_cross_entropy;
  $(predictor, train)(dataset);
  CapyPredictorEvaluation* eval = $(predictor, evaluate)(dataset);
  CUTEST_ASSERT(
    eval->confusionMatrix[0] == 8 &&
    eval->confusionMatrix[1] == 2 &&
    eval->confusionMatrix[2] == 2 &&
    eval->confusionMatrix[3] == 8,
    "train failed %lf", eval->accuracies[capyPredictorAccuracyMeasure_mae]);
  CapyNNPredictorFree(&predictor);
  CapyPredictorEvaluationFree(&eval);
  $(&sigmoid, destruct)();
  CapyDatasetFree(&dataset);
}

CUTEST(test009, "abalone dataset (huber loss)") {
  CapyDataset* dataset = CapyDatasetAlloc();
  char const* pathDataset = "Resources/abalone.csv";
  $(dataset, loadFromPath)(pathDataset);
  CapyNNActivationReLU relu = CapyNNActivationReLUCreate();
  CapyNNModel layerDef = {
    .nbLayer = 2,
    .layers = (CapyNNLayerDef[]){
      {.nbNode = 16, .activation = (CapyNNActivationFun*)&relu},
      {.nbNode = 8, .activation = (CapyNNActivationFun*)&relu},
    },
  };
  CapyNNPredictor* predictor =
    CapyNNPredictorAlloc(&layerDef, capyPredictorType_numerical);
  predictor->verbose = false;
  predictor->featureScaling = capyPredictorFeatureScaling_standardization;
  predictor->timeTraining = 0.0;
  predictor->nbIterTrainMax = 100;
  predictor->seed = 2;
  predictor->batchSize = 1000;
  predictor->lossType = capyNNPredictorLossType_huber;
  $(predictor, train)(dataset);
  CapyPredictorEvaluation* eval = $(predictor, evaluate)(dataset);
  CUTEST_ASSERT(
    fabs(
      eval->accuracies[capyPredictorAccuracyMeasure_mae] - 1.483179) < 1e-6 &&
    fabs(
      eval->accuracies[capyPredictorAccuracyMeasure_rmse] - 2.158766) < 1e-6 &&
    fabs(
      eval->accuracies[capyPredictorAccuracyMeasure_rSquared] -
      0.551586) < 1e-6,
    "train failed %lf %lf %lf",
    eval->accuracies[capyPredictorAccuracyMeasure_mae],
    eval->accuracies[capyPredictorAccuracyMeasure_rmse],
    eval->accuracies[capyPredictorAccuracyMeasure_rSquared]);
  CapyNNPredictorFree(&predictor);
  CapyPredictorEvaluationFree(&eval);
  $(&relu, destruct)();
  CapyDatasetFree(&dataset);
}

