#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "path finding in point cloud") {
  CapyPathFinder* finder = CapyPathFinderAlloc();
  CapyPointCloud pointCloud = CapyPointCloudCreate(1);
  pointCloud.size = 5;
  safeMalloc(pointCloud.points, pointCloud.size);
  loop(i, pointCloud.size) {
    pointCloud.points[i] = CapyVecCreate(1);
    pointCloud.points[i].vals[0] = (double)i;
  }
  pointCloud.nbLink = 14;
  safeMalloc(pointCloud.links, pointCloud.nbLink);
  uint64_t links[14][3] = {
    {0, 1, 3},
    {0, 2, 1},
    {1, 0, 3},
    {1, 2, 7},
    {1, 3, 5},
    {1, 4, 1},
    {2, 0, 1},
    {2, 1, 7},
    {2, 3, 2},
    {3, 1, 5},
    {3, 2, 2},
    {3, 4, 7},
    {4, 1, 1},
    {4, 3, 7},
  };
  loop(i, pointCloud.nbLink) {
    pointCloud.links[i].iPoints[0] = links[i][0];
    pointCloud.links[i].iPoints[1] = links[i][1];
    pointCloud.links[i].weight = (double)(links[i][2]);
  }
  CapyPath path = $(finder, searchPointCloud)(&pointCloud, 0, 3);
  CUTEST_ASSERT(
    path.nbStep == 2,
    "unexpected number of step %lu != 2", path.nbStep);
  CUTEST_ASSERT(
    fabs(path.sumWeight - 3.0) < 1e-9,
    "unexpected sum weight %lf != 3", path.sumWeight);
  CUTEST_ASSERT(
    path.points[0] != 0 || path.points[1] != 2 || path.points[2] != 3,
    "unexpected path [%lu, %lu, %lu] != [0, 2, 3]",
    path.points[0], path.points[1], path.points[2]);
  $(&path, destruct)();
  $(&pointCloud, destruct)();
  CapyPathFinderFree(&finder);
}
