#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "draw bezier") {
  CapyPen* pen = CapyPenAlloc();
  CUTEST_ASSERT(equal(pen->size, 1.5), "unexpected size %lf", pen->size);
  loop(i, 4) {
    CUTEST_ASSERT(
      equal(pen->color.RGBA[i], 1.0),
      "unexpected color [%d]=%lf", i, pen->color.RGBA[i]);
  }
  CapyBezier curve = CapyBezierCreate(2, 1, 2);
  CapyVec* ctrl = curve.ctrls;
  ctrl->vals[0] = 0.0;
  ctrl->vals[1] = 0.0;
  ctrl = curve.ctrls + 1;
  ctrl->vals[0] = 50.0;
  ctrl->vals[1] = 100.0;
  ctrl = curve.ctrls + 2;
  ctrl->vals[0] = 90.0;
  ctrl->vals[1] = 90.0;
  CapyImg img = CapyImgCreate(capyImgMode_rgb, capyImgDims_100x100);
  $(pen, drawBezier)(&curve, &img);
  pen->size = 3;
  pen->color = capyColorRGBARed;
  loop(hardness, 20) {
    pen->hardness = hardness + 1;
    loop(i, 3) {
      ctrl = curve.ctrls + i;
      ctrl->vals[1] = hardness * 5 + 2;
    }
    $(pen, drawBezier)(&curve, &img);
  }
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestPen/pendraw.png", "wb");
  $(&png, saveImg)(&img, &stream);
  $(&stream, open)("UnitTests/TestPen/pendraw.png", "rb");
  CapyImg* img_ = $(&png, loadImg)(&stream);
  $(&stream, open)("UnitTests/TestPen/pendraw_.png", "rb");
  CapyImg* check = $(&png, loadImg)(&stream);
  forEach(pixel, img_->iter) {
    loop(i, 4) {
      CUTEST_ASSERT(
        equal(
          img_->pixels[pixel.idx].RGBA[i], check->pixels[pixel.idx].RGBA[i]
        ),
        "draw failed [%d,%d,%d]=%lf != %lf",
        pixel.pos.x, pixel.pos.y, i,
        img_->pixels[pixel.idx].RGBA[i], check->pixels[pixel.idx].RGBA[i]
      );
    }
  }
  $(&stream, destruct)();
  $(&png, destruct)();
  CapyImgFree(&img_);
  CapyImgFree(&check);
  $(&img, destruct)();
  $(&curve, destruct)();
  CapyPenFree(&pen);
}

CUTEST(test002, "draw geometric shapes") {
  CapyPen* pen = CapyPenAlloc();
  CapyImg img = CapyImgCreate(capyImgMode_rgb, capyImgDims_100x100);
  CapySegment seg = CapySegmentCreate();
  seg.points[0].x = 50.0;
  seg.points[0].y = 20.0;
  seg.points[1].x = 50.0;
  seg.points[1].y = 80.0;
  $(pen, drawSegment)(&seg, &img);
  CapyTriangle tri = CapyTriangleCreate();
  tri.corners[0].x = 10.0;
  tri.corners[0].y = 10.0;
  tri.corners[1].x = 90.0;
  tri.corners[1].y = 10.0;
  tri.corners[2].x = 50.0;
  tri.corners[2].y = 90.0;
  $(pen, drawTriangle)(&tri, &img);
  CapyQuadrilateral quad = CapyQuadrilateralCreate();
  quad.corners[0].x = 20.0;
  quad.corners[0].y = 20.0;
  quad.corners[1].x = 80.0;
  quad.corners[1].y = 20.0;
  quad.corners[2].x = 80.0;
  quad.corners[2].y = 80.0;
  quad.corners[3].x = 20.0;
  quad.corners[3].y = 80.0;
  $(pen, drawQuadrilateral)(&quad, &img);
  CapyRectangle rect = CapyRectangleCreate();
  rect.corners[0].x = 15.0;
  rect.corners[0].y = 25.0;
  rect.corners[1].x = 35.0;
  rect.corners[1].y = 45.0;
  $(pen, drawRectangle)(&rect, &img);
  CapyCircle circle = CapyCircleCreate();
  circle.center.x = 50.0;
  circle.center.y = 50.0;
  circle.radius = 25.0;
  $(pen, drawCircle)(&circle, &img);
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestPen/geometricShapes.png", "wb");
  $(&png, saveImg)(&img, &stream);
  $(&stream, open)("UnitTests/TestPen/geometricShapes.png", "rb");
  CapyImg* img_ = $(&png, loadImg)(&stream);
  $(&stream, open)("UnitTests/TestPen/geometricShapes_.png", "rb");
  CapyImg* check = $(&png, loadImg)(&stream);
  forEach(pixel, img_->iter) {
    loop(i, 4) {
      CUTEST_ASSERT(
        equal(
          img_->pixels[pixel.idx].RGBA[i], check->pixels[pixel.idx].RGBA[i]
        ),
        "draw failed [%d,%d,%d]=%lf != %lf",
        pixel.pos.x, pixel.pos.y, i,
        img_->pixels[pixel.idx].RGBA[i], check->pixels[pixel.idx].RGBA[i]
      );
    }
  }
  $(&stream, destruct)();
  $(&png, destruct)();
  CapyImgFree(&check);
  CapyImgFree(&img_);
  $(&img, destruct)();
  $(&seg, destruct)();
  $(&tri, destruct)();
  $(&quad, destruct)();
  $(&circle, destruct)();
  CapyPenFree(&pen);
}

CUTEST(test003, "draw bezier spline") {
  CapyPen* pen = CapyPenAlloc();
  CapyImgDims dims = { .width = 104, .height = 104 };
  CapyImg img = CapyImgCreate(capyImgMode_rgb, dims);
  size_t nbSegments[1] = {3};
  size_t dimIn = 1;
  uint16_t dimOut = 4;
  CapyBezierOrder_t order = 3;
  CapyBezierSpline spline = CapyBezierSplineCreate(nbSegments, dimIn, dimOut);
  double vals[3][4][4] = {
    {
      {11.0, 54.25, 0, 0}, {14.19, 54.87, 0, 0}, {17.25, 55.0, 0, 0},
      {20.73, 54.75, 0, 0}
    }, {
      {20.73, 54.75, 0, 0}, {41.37, 53.25, 0, 0}, {71.12, 49.63, 0, 0},
      {89.31, 49.51, 0, 0}
    }, {
      {89.31, 49.51, 0, 0}, {92.91, 49.49, 0, 0}, {95.08, 49.75, 0, 0},
      {96.88, 50.0, 0, 0}
    },
  };
  loop(iSegment, 3) {
    CapyBezierFree(spline.curves + iSegment);
    spline.curves[iSegment] = CapyBezierAlloc(order, dimIn, dimOut);
    loop(iCtrl, 4) loop(iVal, dimOut) {
      spline.curves[iSegment]->ctrls[iCtrl].vals[iVal] =
        vals[iSegment][iCtrl][iVal];
    }
  }
  $(pen, drawBezierSpline)(&spline, &img);
  CapyPngFormat png = CapyPngFormatCreate();
  CapyStreamIo stream = CapyStreamIoCreate();
  $(&stream, open)("UnitTests/TestPen/bezierSpline.png", "wb");
  $(&png, saveImg)(&img, &stream);
  $(&stream, open)("UnitTests/TestPen/bezierSpline.png", "rb");
  CapyImg* img_ = $(&png, loadImg)(&stream);
  $(&stream, open)("UnitTests/TestPen/bezierSpline_.png", "rb");
  CapyImg* check = $(&png, loadImg)(&stream);
  forEach(pixel, img_->iter) {
    loop(i, 4) {
      CUTEST_ASSERT(
        equal(
          img_->pixels[pixel.idx].RGBA[i], check->pixels[pixel.idx].RGBA[i]
        ),
        "draw failed [%d,%d,%d]=%lf != %lf",
        pixel.pos.x, pixel.pos.y, i,
        img_->pixels[pixel.idx].RGBA[i], check->pixels[pixel.idx].RGBA[i]
      );
    }
  }
  $(&stream, destruct)();
  CapyImgFree(&check);
  CapyImgFree(&img_);
  $(&png, destruct)();
  $(&img, destruct)();
  CapyPenFree(&pen);
}

CUTEST(test004, "draw arcs") {
  CapyPen* pen = CapyPenAlloc();
  CapyImg* img = CapyImgAlloc(capyImgMode_rgb, capyImgDims_800x800);
  CapyCircle circle = CapyCircleCreate();
  circle.center.x = 400.0;
  circle.center.y = 400.0;
  circle.radius = 390.0;
  CapyPoint2D points[12] = {
    (CapyPoint2D){.x = 0.0, .y = 200.0},
    (CapyPoint2D){.x = 0.0, .y = 400.0},
    (CapyPoint2D){.x = 0.0, .y = 600.0},
    (CapyPoint2D){.x = 200.0, .y = 800.0},
    (CapyPoint2D){.x = 400.0, .y = 800.0},
    (CapyPoint2D){.x = 600.0, .y = 800.0},
    (CapyPoint2D){.x = 800.0, .y = 600.0},
    (CapyPoint2D){.x = 800.0, .y = 400.0},
    (CapyPoint2D){.x = 800.0, .y = 200.0},
    (CapyPoint2D){.x = 600.0, .y = 0.0},
    (CapyPoint2D){.x = 400.0, .y = 0.0},
    (CapyPoint2D){.x = 200.0, .y = 0.0},
  };
  loop(i, 12) loop(j, 12) if(i != j) {
    CapyBezierSpline spline =
      $(&circle, getArcAsBezierSpline)(points + i, points + j);
    $(pen, drawBezierSpline)(&spline, img);
    $(&spline, destruct)();
    circle.radius -= 2.0;
  }
  $(img, saveToPath)("UnitTests/TestPen/arcs.png");
  CapyImg* checkImg = CapyImgLoadFromPath("UnitTests/TestPen/checkArcs.png");
  CUTEST_ASSERT($(img, isSame)(checkImg), "draw arc failed");
  CapyImgFree(&checkImg);
  CapyImgFree(&img);
  $(&circle, destruct)();
  CapyPenFree(&pen);
}
