#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "PoissonSampling getSamples") {
  CapyPoissonSampling* sampling = CapyPoissonSamplingAlloc(1, 2);
  sampling->r = 0.2;
  CapySamples* samples = $(sampling, getSamples)();
  CapyImg* img = CapyImgAlloc(capyImgMode_rgb, capyImgDims_100x100);
  loop(iSample, samples->size) {
    CapySample sample = $(samples, get)(iSample);
    CapyImgPos pos;
    loop(i, 2) pos.coords[i] = (CapyImgPos_t)(100.0 * sample.vals[i]);
    $(img, setColor)(&pos, &capyColorRGBAWhite);
  }
  $(img, saveToPath)("./UnitTests/TestPoissonSampling/samples.png");
  CapyImgFree(&img);
  double check[21][2] = {
    {0.572259, 0.033247},
    {0.057290, 0.279816},
    {0.053237, 0.594259},
    {0.253667, 0.574787},
    {0.532208, 0.308471},
    {0.411690, 0.039390},
    {0.096418, 0.016706},
    {0.239641, 0.800091},
    {0.291044, 0.318703},
    {0.792157, 0.774995},
    {0.602807, 0.498889},
    {0.797911, 0.071761},
    {0.975463, 0.860957},
    {0.526030, 0.710018},
    {0.543409, 0.946651},
    {0.775492, 0.999741},
    {0.331132, 0.990696},
    {0.037785, 0.799817},
    {0.995269, 0.197048},
    {0.978674, 0.627242},
    {0.853036, 0.398186},
  };
  CUTEST_ASSERT(
    samples->size == 21,
    "unexpected number of samples %lu != 21",
    samples->size);
  loop(iSample, (size_t)21) {
    CapySample sample = $(samples, get)(iSample);
    CUTEST_ASSERT(
      fabs(sample.vals[0] - check[iSample][0]) < 0.0001,
      "unexpected value [%lu,0]=%f != %f",
      iSample, sample.vals[0], check[iSample][0]);
    CUTEST_ASSERT(
      fabs(sample.vals[1] - check[iSample][1]) < 0.0001,
      "unexpected value [%lu,1]=%f != %f",
      iSample, sample.vals[1], check[iSample][1]);
  }
  loop(iSample, samples->size) {
    CapySample sample = $(samples, get)(iSample);
    $(&sample, destruct)();
  }
  CapySamplesFree(&samples);
  CapyPoissonSamplingFree(&sampling);
}
