#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "1D Polynomial") {
  CapyVec coeffs = {.dim = 3, .vals = (double[3]){1.0, 2.0, 3.0}};
  CapyPolynomial1D* poly = CapyPolynomial1DAlloc(&coeffs);
  double in[4][1] = {{-2.0}, {0.0}, {1.0}, {2.0}};
  double out[1];
  double checkA[4] = {9.0, 1.0, 6.0, 17.0};
  loop(i, 4) {
    $(poly, eval)(in[i], out);
    CUTEST_ASSERT(
      fabs(out[0] - checkA[i]) < 1e-9,
      "Unexpected value [%d]=%lf != %lf", i, out[0], checkA[i]);
  }
  double checkB[4] = {-10.0, 2.0, 8.0, 14.0};
  loop(i, 4) {
    $(poly, evalDerivative)(in[i], 0, out);
    CUTEST_ASSERT(
      fabs(out[0] - checkB[i]) < 1e-9,
      "Unexpected value [%d]=%lf != %lf", i, out[0], checkB[i]);
  }
  CapyPolynomial1DFree(&poly);
}
