#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Bit operations") {
  short val = 0x1234;
  CUTEST_ASSERT(
    ((char*)&val)[0] == 0x34, "unexpected value %d", ((char*)&val)[0]);
  CUTEST_ASSERT(
    ((char*)&val)[1] == 0x12, "unexpected value %d", ((char*)&val)[1]);
  short valb = val & 0xFF;
  CUTEST_ASSERT(valb == 0x34, "unexpected value %d", valb);
  val = val >> 8;
  CUTEST_ASSERT(
    ((char*)&val)[0] == 0x12, "unexpected value %d", ((char*)&val)[0]);
  CUTEST_ASSERT(
    ((char*)&val)[1] == 0x00, "unexpected value %d", ((char*)&val)[1]);
}

CUTEST(test002, "Random operations (xorshift*)") {
  CapyRandom* rnd = CapyRandomAlloc(0);
  $(rnd, setPrng)(capyRandomPrng_xorshift_star);
  CapyRangeInt8 rangeInt8 = CapyRangeInt8Create(-100, 100);
  CapyRangeDouble rangeDouble = CapyRangeDoubleCreate(-M_PI, M_PI);
  uint64_t ratios[][2] = {
    {2549050247055581086U, 6148914691236517205U},
    {2841410906655099452U, 3689348814741910323U},
    {17423632668206687159U, 18446744073709551615U},
    {15671362200172602802U, 18446744073709551615U},
    {5673805037196922348U, 18446744073709551615U},
    {3872600389809899338U, 18446744073709551615U},
    {175683025072833922U, 217020518514230019U},
    {5881498050347271514U, 6148914691236517205U},
    {2645210781189925749U, 6148914691236517205U},
    {5169904893438157298U, 6148914691236517205U},
  };
  loop(i, 10) {
    uint8_t a8 = $(rnd, getUInt8)();
    uint16_t a16 = $(rnd, getUInt16)();
    uint32_t a32 = $(rnd, getUInt32)();
    uint64_t a64 = $(rnd, getUInt64)();
    (void)a8; (void)a16; (void)a32; (void)a64;
    double b = $(rnd, getDouble)();
    CUTEST_ASSERT(0.0 <= b && b <= 1.0, "unexpected value %lf", b);
    int8_t c = $(rnd, getInt8Range)(&rangeInt8);
    CUTEST_ASSERT(-100 <= c && c <= 100, "unexpected value %d", c);
    double d = $(rnd, getDoubleRange)(&rangeDouble);
    CUTEST_ASSERT(-M_PI <= d && d <= M_PI, "unexpected value %lf", d);
    CapyRatio ratio = $(rnd, getRatio)();
    CUTEST_ASSERT(
      ratio.base == 0 && ratio.num == ratios[i][0] && ratio.den == ratios[i][1],
      "unexpected value %d %ld %lu %lu", i, ratio.base, ratio.num, ratio.den);
  }
  CapyRandomFree(&rnd);
  $(&rangeInt8, destruct)();
  $(&rangeDouble, destruct)();
}

CUTEST(test003, "Random operations (pcg-xsh-rr)") {
  CapyRandom* rnd = CapyRandomAlloc(0);
  CapyRangeInt8 rangeInt8 = CapyRangeInt8Create(-100, 100);
  CapyRangeDouble rangeDouble = CapyRangeDoubleCreate(-M_PI, M_PI);
  uint64_t ratios[][2] = {
    {3003417862592680327U, 6148914691236517205U},
    {16533930758656454801U, 18446744073709551615U},
    {15997480056215196241U, 18446744073709551615U},
    {608342049941615296U, 1085102592571150095U},
    {8768048897220661699U, 18446744073709551615U},
    {8252153945076433051U, 18446744073709551615U},
    {6346446724327943551U, 18446744073709551615U},
    {968794206930304342U, 1229782938247303441U},
    {15786753888563099086U, 18446744073709551615U},
    {5933462973860229512U, 18446744073709551615U},
  };
  loop(i, 10) {
    uint8_t a8 = $(rnd, getUInt8)();
    uint16_t a16 = $(rnd, getUInt16)();
    uint32_t a32 = $(rnd, getUInt32)();
    uint64_t a64 = $(rnd, getUInt64)();
    (void)a8; (void)a16; (void)a32; (void)a64;
    double b = $(rnd, getDouble)();
    CUTEST_ASSERT(0.0 <= b && b <= 1.0, "unexpected value %lf", b);
    int8_t c = $(rnd, getInt8Range)(&rangeInt8);
    CUTEST_ASSERT(-100 <= c && c <= 100, "unexpected value %d", c);
    double d = $(rnd, getDoubleRange)(&rangeDouble);
    CUTEST_ASSERT(-M_PI <= d && d <= M_PI, "unexpected value %lf", d);
    CapyRatio ratio = $(rnd, getRatio)();
    CUTEST_ASSERT(
      ratio.base == 0 && ratio.num == ratios[i][0] && ratio.den == ratios[i][1],
      "unexpected value %d %ld %lu %lu", i, ratio.base, ratio.num, ratio.den);
  }
  CapyRandomFree(&rnd);
  $(&rangeInt8, destruct)();
  $(&rangeDouble, destruct)();
}

CUTEST(test004, "Random operations (squirrel3)") {
  CapyRandom* rnd = CapyRandomAlloc(0);
  uint32_t squirrels[] = {
    436901570, 725778245, 61355516, 3809932532, 2923951477, 4286858955,
    357163824, 2278085025, 1639418064, 2704673657
  };
  loop(i, (uint32_t)10) {
    uint32_t squirrel = $(rnd, getSquirrel3)(i);
    CUTEST_ASSERT(
      squirrel == squirrels[i],
      "unexpected value %u != %u", squirrel, squirrels[i]);
  }
  CapyRandomFree(&rnd);
}

CUTEST(test005, "DistDiscrete operations") {
  CapyRandom rnd = CapyRandomCreate(0);
  CapyDistDiscrete dist = CapyDistDiscreteCreate(3);
  $(dist.occ, set)(
    0, &((CapyDistDiscreteOccurence){.prob = 0.5, .evt = {.id = 0}}));
  $(dist.occ, set)(
    1, &((CapyDistDiscreteOccurence){.prob = 0.3, .evt = {.id = 1}}));
  $(dist.occ, set)(
    2, &((CapyDistDiscreteOccurence){.prob = 0.2, .evt = {.id = 2}}));
  uint16_t choice[3] = {0, 0, 0};
  loop(i, 100000) {
    CapyDistEvt evt = $(&rnd, getDistEvt)((CapyDist*)&dist);
    ++(choice[evt.id]);
  }
  CUTEST_ASSERT(
    fabs(0.5 - (double)choice[0] / 100000.0) < 1e-2,
    "unexpected value %u", choice[0]);
  CUTEST_ASSERT(
    fabs(0.3 - (double)choice[1] / 100000.0) < 1e-2,
    "unexpected value %u", choice[1]);
  CUTEST_ASSERT(
    fabs(0.2 - (double)choice[2] / 100000.0) < 1e-2,
    "unexpected value %u", choice[2]);
  $(&dist, destruct)();
  $(&rnd, destruct)();
}

#if CAPY_ARCH_X86 == 1
CUTEST(test006, "True random value") {
  uint32_t val = CapyGetTrulyRandomValue();
  CUTEST_ASSERT(val == val, " ");
}

#endif
CUTEST(test007, "Seed type size") {
  CUTEST_ASSERT(
    sizeof(CapyRandomSeed_t) == sizeof(uint64_t),
    "sizeof(CapyRandomSeed_t) = %lu, sizeof(uint64_t) = %lu",
    sizeof(CapyRandomSeed_t), sizeof(uint64_t));
}

CUTEST(test008, "Lemire's algorithm (1)") {
  CapyRandom* rnd = CapyRandomAlloc(0);
  CapyRangeUInt32 rangeUInt32 = CapyRangeUInt32Create(10, 100);
  uint32_t check[10] = {33, 15, 32, 39, 53, 27, 63, 53, 33, 24};
  loop(i, 10) {
    uint32_t v = $(rnd, getUInt32RangeLemire)(&rangeUInt32);
    CUTEST_ASSERT(v == check[i], "v[%d]=%u != %u", i, v, check[i]);
  }
  CapyRandomFree(&rnd);
  $(&rangeUInt32, destruct)();
}

CUTEST(test009, "Lemire's algorithm (2)") {
  CapyRandom* rnd = CapyRandomAlloc(0);
  CapyRangeUInt32 rangeUInt32 = CapyRangeUInt32Create(10, 100);
  CapyChrono chrono = CapyChronoCreate();
  uint32_t sum = 0;
  $(&chrono, start)();
  loop(i, 1000000) {
    sum += $(rnd, getUInt32RangeLemire)(&rangeUInt32);
  }
  $(&chrono, stop)();
  double timeLemireMs = $(&chrono, getElapsedTime)(capyChrono_millisecond);
  $(&chrono, start)();
  loop(i, 1000000) {
    sum += $(rnd, getUInt32Range)(&rangeUInt32);
  }
  $(&chrono, stop)();
  double timeDefaultMs = $(&chrono, getElapsedTime)(capyChrono_millisecond);
  if(timeLemireMs < timeDefaultMs) {
    printf(
      "\nWarning: Lemire slower than expected %lf<%lf\n",
      timeLemireMs, timeDefaultMs);
  }
  CUTEST_ASSERT(true, "ok\n");
  CapyRandomFree(&rnd);
  $(&rangeUInt32, destruct)();
}

CUTEST(test010, "Lemire's algorithm (3)") {
  CapyRandom* rnd = CapyRandomAlloc(0);
  CapyRangeUInt32 rangeUInt32 = CapyRangeUInt32Create(10, 100);
  loop(i, 1000000) {
    uint32_t v = $(rnd, getUInt32RangeLemire)(&rangeUInt32);
    CUTEST_ASSERT(
      v >= rangeUInt32.min && v <= rangeUInt32.max, "v=%u out of range", v);
  }
  CapyRandomFree(&rnd);
  $(&rangeUInt32, destruct)();
}

