#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#define CHECK_OFFSET(T)                                 \
  CUTEST_ASSERT(                                        \
    offsetof(T, min) == offsetof(T, vals[0]),           \
    "offset of min and vals[0] doesn't match %lu!=%lu", \
    offsetof(T, min), offsetof(T, vals[0]));            \
  CUTEST_ASSERT(                                        \
    offsetof(T, max) == offsetof(T, vals[1]),           \
    "offset of max and vals[1] doesn't match %lu!=%lu", \
    offsetof(T, max), offsetof(T, vals[1]))
#endif
CUTEST(test001, "Range operations") {
  CapyRangeInt8* range = CapyRangeInt8Alloc(0, 10);
  int8_t val = $(range, trim)(-1);
  CUTEST_ASSERT(val == 0, "unexpected value %d", val);
  val = $(range, trim)(0);
  CUTEST_ASSERT(val == 0, "unexpected value %d", val);
  val = $(range, trim)(1);
  CUTEST_ASSERT(val == 1, "unexpected value %d", val);
  val = $(range, trim)(10);
  CUTEST_ASSERT(val == 10, "unexpected value %d", val);
  val = $(range, trim)(11);
  CUTEST_ASSERT(val == 10, "unexpected value %d", val);
  CapyRangeInt8Free(&range);
  CUTEST_ASSERT(range == NULL, "range not reset");
}

CUTEST(test002, "Padding") {
  CHECK_OFFSET(CapyRangeInt8);
  CHECK_OFFSET(CapyRangeInt16);
  CHECK_OFFSET(CapyRangeInt32);
  CHECK_OFFSET(CapyRangeInt64);
  CHECK_OFFSET(CapyRangeUInt8);
  CHECK_OFFSET(CapyRangeUInt16);
  CHECK_OFFSET(CapyRangeUInt32);
  CHECK_OFFSET(CapyRangeUInt64);
  CHECK_OFFSET(CapyRangeFloat);
  CHECK_OFFSET(CapyRangeDouble);
}
