#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#define NB_TEST_VALS 28
CapyRatio testVals[NB_TEST_VALS] = {
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = UINT64_MAX-1, .den = UINT64_MAX},
  {.base = INT64_MIN+1, .num = 0, .den = 1},
  {.base = INT64_MIN+1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN+1, .num = 1, .den = 2},
  {.base = INT64_MIN+1, .num = UINT64_MAX-1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX-1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX-1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = 1, .den = UINT64_MAX},
  {.base = 1, .num = 1, .den = 2},
  {.base = 1, .num = UINT64_MAX-1, .den = UINT64_MAX},
  {.base = INT64_MAX-1, .num = 0, .den = 1},
  {.base = INT64_MAX-1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX-1, .num = 1, .den = 2},
  {.base = INT64_MAX-1, .num = UINT64_MAX-1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = UINT64_MAX-1, .den = UINT64_MAX},
};

CapyRatio checkValsAdd[] = {
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -2, .num = 0, .den = 1},
  {.base = -2, .num = 1, .den = UINT64_MAX},
  {.base = -2, .num = 1, .den = 2},
  {.base = -2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = -2, .num = 1, .den = UINT64_MAX},
  {.base = -2, .num = 2, .den = UINT64_MAX},
  {.base = -2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -2, .num = 1, .den = 2},
  {.base = -2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 2, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = -2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 1, .den = 2},
  {.base = INT64_MIN + 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 3, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 2, .num = 1, .den = 2},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 3, .num = 0, .den = 1},
  {.base = INT64_MIN + 3, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 2, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 3, .num = 0, .den = 1},
  {.base = INT64_MIN + 3, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 3, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -2, .num = 0, .den = 1},
  {.base = -2, .num = 1, .den = UINT64_MAX},
  {.base = -2, .num = 1, .den = 2},
  {.base = -2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 2, .num = 0, .den = 1},
  {.base = INT64_MAX - 2, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 2, .num = 1, .den = 2},
  {.base = INT64_MAX - 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = -2, .num = 1, .den = UINT64_MAX},
  {.base = -2, .num = 2, .den = UINT64_MAX},
  {.base = -2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 2, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 2, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -2, .num = 1, .den = 2},
  {.base = -2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX - 2, .num = 1, .den = 2},
  {.base = INT64_MAX - 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = -2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = 1, .den = UINT64_MAX},
  {.base = 1, .num = 1, .den = 2},
  {.base = 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = 1, .den = UINT64_MAX},
  {.base = 1, .num = 2, .den = UINT64_MAX},
  {.base = 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 2, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 1, .num = 1, .den = 2},
  {.base = 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 2, .num = 0, .den = 1},
  {.base = 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 2, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 2, .num = 0, .den = 1},
  {.base = 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 2, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 1, .den = 2},
  {.base = INT64_MIN + 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = 1, .den = UINT64_MAX},
  {.base = 1, .num = 1, .den = 2},
  {.base = 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 2, .num = 0, .den = 1},
  {.base = 2, .num = 1, .den = UINT64_MAX},
  {.base = 2, .num = 1, .den = 2},
  {.base = 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 3, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = 1, .den = UINT64_MAX},
  {.base = 1, .num = 2, .den = UINT64_MAX},
  {.base = 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 2, .num = 0, .den = 1},
  {.base = 2, .num = 1, .den = UINT64_MAX},
  {.base = 2, .num = 2, .den = UINT64_MAX},
  {.base = 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 3, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 2, .num = 1, .den = 2},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 3, .num = 0, .den = 1},
  {.base = INT64_MIN + 3, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 1, .num = 1, .den = 2},
  {.base = 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 2, .num = 0, .den = 1},
  {.base = 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 2, .num = 1, .den = 2},
  {.base = 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 3, .num = 0, .den = 1},
  {.base = 3, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 2, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 3, .num = 0, .den = 1},
  {.base = INT64_MIN + 3, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 3, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 2, .num = 0, .den = 1},
  {.base = 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 2, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 3, .num = 0, .den = 1},
  {.base = 3, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 3, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = -2, .num = 0, .den = 1},
  {.base = -2, .num = 1, .den = UINT64_MAX},
  {.base = -2, .num = 1, .den = 2},
  {.base = -2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 2, .num = 0, .den = 1},
  {.base = INT64_MAX - 2, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 2, .num = 1, .den = 2},
  {.base = INT64_MAX - 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = -2, .num = 1, .den = UINT64_MAX},
  {.base = -2, .num = 2, .den = UINT64_MAX},
  {.base = -2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = INT64_MAX - 2, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 2, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = -2, .num = 1, .den = 2},
  {.base = -2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX - 2, .num = 1, .den = 2},
  {.base = INT64_MAX - 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = -2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
};

CapyRatio checkValsMul[] = {
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MAX, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX / 2 + 1, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX / 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = 3, .den = 4},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 1, .den = 4},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX / 6 + 1, .den = UINT64_MAX / 3},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX / 2, .num = 1, .den = 4UL},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 3UL, .den = 4UL},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {
    .base = 9223372036854775805L,
    .num = UINT64_MAX / 6 + 1, .den = UINT64_MAX / 3
  }, {.base = INT64_MAX / 2, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 10, .den = 3689348814741910323UL},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -2, .num = 1, .den = 2},
  {.base = -2, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {
    .base = 9223372036854775805L,
    .num = UINT64_MAX / 6 + 1, .den = UINT64_MAX / 3
  }, {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -2, .num = 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 10, .den = 3689348814741910323UL},
  {
    .base = INT64_MIN + 1,
    .num = 12297829382473034409UL, .den = 12297829382473034410UL
  }, {.base = INT64_MIN + 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX / 2 + 1, .num = 0, .den = 1},
  {.base = INT64_MAX / 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = 3UL, .den = 4UL},
  {.base = INT64_MAX / 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = 1, .den = 2},
  {.base = INT64_MAX / 2, .num = UINT64_MAX / 6, .den = 6148914691236517205L},
  {.base = INT64_MAX / 2, .num = 1, .den = 4UL},
  {.base = INT64_MAX / 2, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 1, .den = 4UL},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 3UL, .den = 4UL},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -1, .num = 1, .den = 4UL},
  {.base = -1, .num = 0, .den = 1},
  {.base = -4611686018427387903L, .num = 0, .den = 1},
  {.base = INT64_MIN / 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 3UL, .den = 4UL},
  {.base = INT64_MIN / 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 1, .den = 2},
  {.base = INT64_MIN / 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN / 2, .num = 1, .den = 4UL},
  {.base = INT64_MIN / 2, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 6 + 1, .den = UINT64_MAX / 3},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 0, .den = 1},
  {.base = INT64_MIN / 2, .num = 0, .den = 1},
  {.base = INT64_MIN / 2, .num = 1, .den = 4UL},
  {.base = INT64_MIN / 2, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 1, .den = 2},
  {.base = INT64_MIN / 2, .num = 1, .den = 2},
  {.base = INT64_MIN / 2, .num = 3UL, .den = 4UL},
  {.base = INT64_MIN / 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = 3UL, .den = 4UL},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = 4UL},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = 3UL, .den = 4UL},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = 0, .den = 1},
  {.base = INT64_MAX / 2, .num = 0, .den = 1},
  {.base = INT64_MAX / 2, .num = 1, .den = 4UL},
  {.base = INT64_MAX / 2, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = 1, .den = 2},
  {.base = INT64_MAX / 2, .num = 1, .den = 2},
  {.base = INT64_MAX / 2, .num = 3UL, .den = 4UL},
  {.base = INT64_MAX / 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 10, .den = 3689348814741910323UL},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 1, .num = 6148914691236517204UL, .den = UINT64_MAX / 3},
  {
    .base = 9223372036854775805L,
    .num = UINT64_MAX / 6 + 1, .den = UINT64_MAX / 3
  }, {
    .base = 9223372036854775805L,
    .num = UINT64_MAX / 6 + 1, .den = UINT64_MAX / 3
  }, {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN, .num = 0, .den = 1},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 1, .num = 0, .den = 1},
  {.base = 1, .num = 1, .den = UINT64_MAX},
  {.base = 1, .num = 1, .den = 2},
  {.base = 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX / 6 + 1, .den = UINT64_MAX / 3},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = -2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 1, .den = 2},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 1, .num = 1, .den = UINT64_MAX},
  {.base = 1, .num = 2, .den = UINT64_MAX},
  {.base = 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 2, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {
    .base = INT64_MAX - 1,
    .num = 12297829382473034409UL, .den = 12297829382473034410UL
  }, {.base = INT64_MAX, .num = UINT64_MAX / 10, .den = 3689348814741910323UL},
  {.base = INT64_MAX, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = -2, .num = 1, .den = 2},
  {.base = -2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = 1, .den = 4UL},
  {.base = -1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = 3UL, .den = 4UL},
  {.base = 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 1, .num = 1, .den = 2},
  {.base = 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 2, .num = 1, .den = 4UL},
  {.base = 2, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = -2, .num = 1, .den = UINT64_MAX},
  {.base = -2, .num = 2, .den = UINT64_MAX},
  {.base = -1, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = 1, .den = UINT64_MAX},
  {.base = 0, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 1, .num = 6148914691236517204UL, .den = UINT64_MAX / 3},
  {.base = 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 2, .num = 0, .den = 1},
  {.base = 2, .num = UINT64_MAX - 2, .den = UINT64_MAX},
  {.base = 3, .num = 18446744073709551611UL, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN + 2, .num = 0, .den = 1},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -4611686018427387903L, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 6 + 1, .den = UINT64_MAX / 3},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX / 2, .num = 0, .den = 1},
  {
    .base = 9223372036854775805L,
    .num = UINT64_MAX / 6 + 1, .den = UINT64_MAX / 3
  }, {.base = INT64_MAX - 1, .num = 0, .den = 1},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN + 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 2, .num = UINT64_MAX / 10, .den = 3689348814741910323UL},
  {.base = INT64_MIN / 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX / 2, .num = 0, .den = 1},
  {
    .base = 9223372036854775805L,
    .num = UINT64_MAX / 6 + 1, .den = UINT64_MAX / 3
  }, {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN + 1, .num = 1, .den = 2},
  {
    .base = INT64_MIN + 1,
    .num = 12297829382473034409UL, .den = 12297829382473034410UL
  }, {.base = INT64_MIN / 2, .num = 3UL, .den = 4UL},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX / 2, .num = 1, .den = 4UL},
  {.base = INT64_MAX - 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = 1, .den = 2},
  {
    .base = INT64_MAX - 1,
    .num = 12297829382473034409UL, .den = 12297829382473034410UL
  }, {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN + 1, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX / 2, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX - 1, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX / 10, .den = 3689348814741910323UL},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN + 1, .num = 0, .den = 1},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 1, .den = 2},
  {.base = -1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN + 1, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MIN / 2, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = 1, .den = 2},
  {.base = INT64_MAX - 1, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 1, .den = 2},
  {.base = INT64_MIN, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 1, .den = 4UL},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = 3UL, .den = 4UL},
  {.base = INT64_MAX, .num = 0, .den = 1},
  {.base = INT64_MAX, .num = 1, .den = 2},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = INT64_MIN, .num = 1, .den = UINT64_MAX},
  {.base = INT64_MIN, .num = UINT64_MAX / 2 + 1, .den = UINT64_MAX},
  {.base = INT64_MIN / 2, .num = 0, .den = 1},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX},
  {.base = INT64_MAX / 2, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = INT64_MAX, .num = UINT64_MAX / 6, .den = UINT64_MAX / 3},
  {.base = INT64_MAX, .num = UINT64_MAX - 1, .den = UINT64_MAX},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
};

CapyRatio checkValsInv[] = {
  {.base = 0, .num = 0, .den = 0},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX / 2 + 1},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX / 2 + 1},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX / 2 + 1},
  {.base = -1, .num = UINT64_MAX / 2 - 1, .den = UINT64_MAX / 2},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX / 2 + 1},
  {.base = -1, .num = 18446744073709551611UL, .den = UINT64_MAX - 2},
  {.base = -1, .num = UINT64_MAX / 2, .den = UINT64_MAX / 2 + 1},
  {.base = -1, .num = 0, .den = 1},
  {.base = -2, .num = UINT64_MAX - 2, .den = UINT64_MAX - 1},
  {.base = -2, .num = 0, .den = 1},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 0, .num = 0, .den = 0},
  {.base = 2, .num = 0, .den = 1},
  {.base = 1, .num = 1, .den = UINT64_MAX - 1},
  {.base = 1, .num = 0, .den = 1},
  {.base = 0, .num = UINT64_MAX / 2, .den = UINT64_MAX / 2 + 1},
  {.base = 0, .num = 2, .den = 3UL},
  {.base = 0, .num = 4611686018427387905UL, .den = UINT64_MAX / 2 + 1},
  {.base = 0, .num = 1, .den = UINT64_MAX / 2 - 1},
  {.base = 0, .num = 1, .den = UINT64_MAX / 2 + 1},
  {.base = 0, .num = 2, .den = UINT64_MAX - 2},
  {.base = 0, .num = 1, .den = UINT64_MAX / 2 + 1},
  {.base = 0, .num = 1, .den = UINT64_MAX / 2},
  {.base = 0, .num = 1, .den = UINT64_MAX / 2 + 1},
  {.base = 0, .num = 1, .den = UINT64_MAX / 2 + 1},
  {.base = 0, .num = 1, .den = UINT64_MAX / 2 + 1},
};

#endif
CUTEST(test001, "create, reduce") {
  try {
    CapyRatio a = CapyRatioCreate(0, 0, 1);
    CUTEST_ASSERT(
      a.base == 0 && a.num == 0 && a.den == 1,
      "unexpected value %ld %lu %lu", a.base, a.num, a.den);
    a = CapyRatioReduce(a);
    CUTEST_ASSERT(
      a.base == 0 && a.num == 0 && a.den == 1,
      "unexpected value %ld %lu %lu", a.base, a.num, a.den);
    CapyRatio b = CapyRatioCreate(1, 2, 3);
    CUTEST_ASSERT(
      b.base == 1 && b.num == 2 && b.den == 3,
      "unexpected value %ld %lu %lu", b.base, b.num, b.den);
    b = CapyRatioReduce(b);
    CUTEST_ASSERT(
      b.base == 1 && b.num == 2 && b.den == 3,
      "unexpected value %ld %lu %lu", b.base, b.num, b.den);
    b.num = 6;
    b = CapyRatioReduce(b);
    CUTEST_ASSERT(
      b.base == 3 && b.num == 0,
      "unexpected value %ld %lu %lu", b.base, b.num, b.den);
    b.num = 2;
    b.den = 4;
    b = CapyRatioReduce(b);
    CUTEST_ASSERT(
      b.base == 3 && b.num == 1 && b.den == 2,
      "unexpected value %ld %lu %lu", b.base, b.num, b.den);
    CUTEST_ASSERT(!CapyRatioIsNaN(b), "isNan failed");
    b = CapyRatioCreate(0, (uint64_t)INT64_MAX + 1, 1);
    b = CapyRatioReduce(b);
    CUTEST_ASSERT(CapyRatioIsNaN(b), "isNan failed");
    b = CapyRatioCreate(0, (uint64_t)INT64_MAX, 1);
    b = CapyRatioReduce(b);
    CUTEST_ASSERT(
      b.base == INT64_MAX && b.num == 0 && b.den == 1,
      "unexpected value %ld %lu %lu", b.base, b.num, b.den);
    b = CapyRatioCreate(0, 2 * (uint64_t)INT64_MAX + 1, 1);
    b = CapyRatioReduce(b);
    CUTEST_ASSERT(CapyRatioIsNaN(b), "isNan failed");
    b = CapyRatioCreate(-1, (uint64_t)INT64_MAX + 2, 1);
    b = CapyRatioReduce(b);
    CUTEST_ASSERT(CapyRatioIsNaN(b), "isNan failed");
    b = CapyRatioCreate(-1, (uint64_t)INT64_MAX + 1, 1);
    b = CapyRatioReduce(b);
    CUTEST_ASSERT(
      b.base == INT64_MAX && b.num == 0 && b.den == 1,
      "unexpected value %ld %lu %lu", b.base, b.num, b.den);
    b = CapyRatioCreate(INT64_MIN, 2 * (uint64_t)INT64_MAX + 1, 1);
    b = CapyRatioReduce(b);
    CUTEST_ASSERT(
      b.base == INT64_MAX && b.num == 0 && b.den == 1,
      "unexpected value %ld %lu %lu", b.base, b.num, b.den);
    b = CapyRatioCreate(INT64_MAX, 2, 1);
    b = CapyRatioReduce(b);
    CUTEST_ASSERT(CapyRatioIsNaN(b), "isNan failed");
  } endCatch;
  CapyCancelExc();
}

CUTEST(test002, "from/to double") {
  CapySetRaiseStream(NULL);
  CapyRatio a = CapyRatioFromDouble(0.0);
  CUTEST_ASSERT(
    a.base == 0 && a.num == 0 && a.den == 1,
    "unexpected value %ld %lu %lu", a.base, a.num, a.den);
  double v = CapyRatioToDouble(a);
  CUTEST_ASSERT(equald(0.0, v), "unexpected value %lf", v);
  a = CapyRatioFromDouble(0.5);
  CUTEST_ASSERT(
    a.base == 0 && a.num == 1 && a.den == 2,
    "unexpected value %ld %lu %lu", a.base, a.num, a.den);
  v = CapyRatioToDouble(a);
  CUTEST_ASSERT(equald(0.5, v), "unexpected value %lf", v);
  a = CapyRatioFromDouble(-0.5);
  CUTEST_ASSERT(
    a.base == -1 && a.num == 1 && a.den == 2,
    "unexpected value %ld %lu %lu", a.base, a.num, a.den);
  v = CapyRatioToDouble(a);
  CUTEST_ASSERT(equald(-0.5, v), "unexpected value %lf", v);
  a = CapyRatioFromDouble(1.0);
  CUTEST_ASSERT(
    a.base == 1 && a.num == 0 && a.den == 1,
    "unexpected value %ld %lu %lu", a.base, a.num, a.den);
  v = CapyRatioToDouble(a);
  CUTEST_ASSERT(equald(1.0, v), "unexpected value %lf", v);
  a = CapyRatioFromDouble(0.3);
  CUTEST_ASSERT(
    a.base == 0 && a.num == 3 && a.den == 10,
    "unexpected value %ld %lu %lu", a.base, a.num, a.den);
  v = CapyRatioToDouble(a);
  CUTEST_ASSERT(equald(0.3, v), "unexpected value %lf", v);
  a = CapyRatioFromDouble(-0.3);
  CUTEST_ASSERT(
    a.base == -1 && a.num == 7 && a.den == 10,
    "unexpected value %ld %lu %lu", a.base, a.num, a.den);
  v = CapyRatioToDouble(a);
  CUTEST_ASSERT(equald(-0.3, v), "unexpected value %lf", v);
  a = CapyRatioFromDouble(0.333);
  CUTEST_ASSERT(
    a.base == 0 && a.num == 333 && a.den == 1000,
    "unexpected value %ld %lu %lu", a.base, a.num, a.den);
  v = CapyRatioToDouble(a);
  CUTEST_ASSERT(equald(0.333, v), "unexpected value %lf", v);
  a = CapyRatioFromDouble((double)1.0 / (double)3.0);
  CUTEST_ASSERT(
    a.base == 0 && a.num == 1 && a.den == 3,
    "unexpected value %ld %lu %lu", a.base, a.num, a.den);
  v = CapyRatioToDouble(a);
  CUTEST_ASSERT(equald(1.0 / 3.0, v), "unexpected value %lf", v);
  a = CapyRatioFromDouble(M_PI);
  CUTEST_ASSERT(
    a.base == 3 && a.num == 3612111 && a.den == 25510582,
    "unexpected value %ld %lu %lu", a.base, a.num, a.den);
  v = CapyRatioToDouble(a);
  CUTEST_ASSERT(equald(M_PI, v), "unexpected value %lf", v);
  try {
    CapyRatio overflow = CapyRatioFromDouble(DBL_MAX);
    CUTEST_ASSERT(false && overflow.base == 0, "unhandled overflow");
  } catch(CapyExc_NumericalOverflow) {
    CUTEST_ASSERT(true, "overflow handled correctly");
  } endCatch;
  try {
    CapyRatio overflow = CapyRatioFromDouble(-DBL_MAX);
    CUTEST_ASSERT(false && overflow.base == 0, "unhandled overflow");
  } catch(CapyExc_NumericalOverflow) {
    CUTEST_ASSERT(true, "overflow handled correctly");
  } endCatch;
  union {uint64_t i; double d;} w;
  w.d = 1.0;
  --(w.i);
  a = CapyRatioFromDouble(w.d);
  CUTEST_ASSERT(
    a.base == 0 &&
    a.num == 9007199254740991 && a.den == 9007199254740992,
    "unexpected value %ld %lu %lu", a.base, a.num, a.den);
  v = CapyRatioToDouble(a);
  CUTEST_ASSERT(equald(w.d, v), "unexpected value %lf", v);
  CapySetRaiseStream(stderr);
}

CUTEST(test003, "addition") {
  CapySetRaiseStream(NULL);
  try {
    int iCheck = 0;
    loop(i, NB_TEST_VALS) loop(j, NB_TEST_VALS) {
      CapyRatio a = CapyRatioAdd(testVals[i], testVals[j]);
      CUTEST_ASSERT(
        a.base == checkValsAdd[iCheck].base &&
        a.num == checkValsAdd[iCheck].num &&
        a.den == checkValsAdd[iCheck].den,
        "unexpected value %ld != %ld, %lu != %lu, %lu != %lu",
        a.base, checkValsAdd[iCheck].base,
        a.num, checkValsAdd[iCheck].num,
        a.den, checkValsAdd[iCheck].den);
      ++iCheck;
    }
  } catch(CapyExc_NumericalOverflow) {
    CUTEST_ASSERT(true, "overflow handled correctly");
  } endCatch;
  CapySetRaiseStream(stderr);
}

CUTEST(test004, "negation") {
  CapySetRaiseStream(NULL);
  try {
    loop(i, NB_TEST_VALS) {
      CapyRatio a = CapyRatioNeg(testVals[i]);
      CapyRatio b = CapyRatioNeg(a);
      CapyRatio c = CapyRatioAdd(a, testVals[i]);
      if(testVals[i].base == INT64_MIN && testVals[i].num == 0) {
        CUTEST_ASSERT(CapyRatioIsNaN(a), "overflow undetected");
      } else {
        CUTEST_ASSERT(
          b.base == testVals[i].base &&
          b.num == testVals[i].num && b.den == testVals[i].den,
          "unexpected value %ld != %ld, %lu != %lu, %lu != %lu",
          b.base, testVals[i].base,
          b.num, testVals[i].num,
          b.den, testVals[i].den);
        CUTEST_ASSERT(
          c.base == 0 && c.num == 0 && c.den == 1,
          "negation failed %ld %lu %lu", c.base, c.num, c.den);
      }
    }
  } catch(CapyExc_NumericalOverflow) {
    CUTEST_ASSERT(true, "overflow handled correctly");
  } endCatch;
  CapySetRaiseStream(stderr);
}

CUTEST(test005, "comparison") {
  CapySetRaiseStream(NULL);
  loop(i, NB_TEST_VALS) loop(j, NB_TEST_VALS) {
    int8_t cmp = CapyRatioCmp(testVals[i], testVals[j]);
    if(i == j) {
      CUTEST_ASSERT(cmp == 0, "comparison failed %d", cmp);
    } else if(i < j) {
      CUTEST_ASSERT(cmp == -1, "comparison failed %d", cmp);
    } else {
      CUTEST_ASSERT(cmp == 1, "comparison failed %d", cmp);
    }
  }
  CapySetRaiseStream(stderr);
}

CUTEST(test006, "multiplication") {
  CapySetRaiseStream(NULL);
  try {
    int iCheck = 0;
    loop(i, NB_TEST_VALS) loop(j, NB_TEST_VALS) {
      CapyRatio a = CapyRatioMul(testVals[i], testVals[j]);
      CUTEST_ASSERT(
        a.base == checkValsMul[iCheck].base &&
        a.num == checkValsMul[iCheck].num &&
        a.den == checkValsMul[iCheck].den,
        "unexpected value %ld != %ld, %lu != %lu, %lu != %lu",
        a.base, checkValsMul[iCheck].base,
        a.num, checkValsMul[iCheck].num,
        a.den, checkValsMul[iCheck].den);
      ++iCheck;
    }
  } catch(CapyExc_NumericalOverflow) {
    CUTEST_ASSERT(true, "overflow handled correctly");
  } endCatch;
  CapySetRaiseStream(stderr);
}

CUTEST(test007, "inversion") {
  CapySetRaiseStream(NULL);
  try {
    loop(i, NB_TEST_VALS) {
      CapyRatio a = CapyRatioInv(testVals[i]);
      CUTEST_ASSERT(
        a.base == checkValsInv[i].base &&
        a.num == checkValsInv[i].num && a.den == checkValsInv[i].den,
        "unexpected value %ld != %ld, %lu != %lu, %lu != %lu",
        a.base, checkValsInv[i].base,
        a.num, checkValsInv[i].num,
        a.den, checkValsInv[i].den);
      if(a.den != 0) {
        if(testVals[i].base == INT64_MIN && testVals[i].num == 0) {
          CUTEST_ASSERT(CapyRatioIsNaN(a), "overflow not handled");
        } else {
          CapyRatio b = CapyRatioInv(a);
          if(b.den != 0) {
            CapyRatio diff = CapyRatioAbs(CapyRatioSub(b, testVals[i]));
            CapyRatio threshold = {.base = 0, .num = 8, .den = UINT64_MAX};
            int cmp = CapyRatioCmp(diff, threshold);
            CUTEST_ASSERT(
              cmp < 0,
              "inversion failed %ld %lu %lu", b.base, b.num, b.den);
          }
          CapyRatio c = CapyRatioMul(a, testVals[i]);
          CapyRatio one = {.base = 1, .num = 0, .den = 1};
          CapyRatio diff = CapyRatioAbs(CapyRatioSub(c, one));
          CapyRatio threshold = {.base = 0, .num = 6, .den = UINT64_MAX};
          int cmp = CapyRatioCmp(diff, threshold);
          CUTEST_ASSERT(
            cmp < 0,
            "inversion failed %ld %lu %lu", b.base, b.num, b.den);
        }
      }
    }
  } catch(CapyExc_NumericalOverflow) {
    CUTEST_ASSERT(true, "overflow handled correctly");
  } endCatch;
  CapySetRaiseStream(stderr);
}

CUTEST(test008, "powi") {
  CapySetRaiseStream(NULL);
  try {
    loop(i, NB_TEST_VALS) {
      CapyRatio a = CapyRatioPowi(testVals[i], 0);
      CUTEST_ASSERT (
        a.base == 1 && a.num == 0 && a.den == 1,
        "unexpected value %ld %lu %lu",
        a.base, a.num, a.den);
      a = CapyRatioPowi(testVals[i], 1);
      CUTEST_ASSERT (
        a.base == testVals[i].base &&
        a.num == testVals[i].num && a.den == testVals[i].den,
        "unexpected value %ld != %ld, %lu != %lu, %lu != %lu",
        a.base, testVals[i].base,
        a.num, testVals[i].num,
        a.den, testVals[i].den);
      loop(n, 10) {
        a = CapyRatioPowi(testVals[i], 2 + n);
        CapyRatio b = testVals[i];
        loop(j, n + 1) b = CapyRatioMul(b, testVals[i]);
        if(CapyRatioIsNaN(a)) {
          CUTEST_ASSERT(CapyRatioIsNaN(b), "overflow unhandled");
        } else {
          CapyRatio diff = CapyRatioAbs(CapyRatioSub(b, a));
          CapyRatio threshold = {.base = 0, .num = 5, .den = UINT64_MAX};
          int cmp = CapyRatioCmp(diff, threshold);
          CUTEST_ASSERT(
            cmp < 0,
            "powi failed %ld %lu %lu", a.base, a.num, a.den);
        }
      }
    }
  } catch(CapyExc_NumericalOverflow) {
    CUTEST_ASSERT(true, "overflow handled correctly");
  } endCatch;
  CapySetRaiseStream(stderr);
}

CUTEST(test009, "sqrt") {
  CapySetRaiseStream(NULL);
  try {
    loop(i, NB_TEST_VALS) {
      CapyRatio a = CapyRatioSqrt(testVals[i]);
      if(testVals[i].base < 0) {
        CUTEST_ASSERT(CapyRatioIsNaN(a), "overflow unhandled");
      } else {
        double valDbl = sqrt(CapyRatioToDouble(testVals[i]));
        double aDbl = CapyRatioToDouble(a);
        double diff = fabs(aDbl - valDbl);
        CUTEST_ASSERT(
          diff < 0.48,
          "sqrt failed %ld %lu %lu", a.base, a.num, a.den);
      }
    }
    CapyRatio a = {40000, 183055000430270644UL, 18446744073709551615UL};
    CapyRatio b = CapyRatioSqrt(a);
    CUTEST_ASSERT(
      b.base == 200 &&
      b.num == 457637472726899UL && b.den == UINT64_MAX,
      "sqrt failed %ld %lu %lu", b.base, b.num, b.den);
  } catch(CapyExc_NumericalOverflow) {
    CUTEST_ASSERT(true, "overflow handled correctly");
  } endCatch;
  CapySetRaiseStream(stderr);
}
