#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Key generation") {
  uint64_t const ps[5] = {61, 11, 7, 53, 11922649};
  uint64_t const qs[5] = {53, 5, 17, 59, 74112287};
  uint64_t const ds[5] = {173, 13, 17, 1109, 426228107209745};
  uint64_t const ns[5] = {3233, 55, 119, 3127, 883614784488263};
  uint64_t const es[5] = {257, 17, 17, 257, 65537};
  CapyRSACipher* rsa = CapyRSACipherAlloc();
  loop(i, 5) {
    $(rsa, generateKeys)(ps[i], qs[i]);
    CUTEST_ASSERT(
      rsa->keys.d == ds[i] &&
      rsa->keys.n == ns[i] &&
      rsa->keys.e == es[i],
      "p = %lu, q = %lu, d = %lu, n = %lu, e = %lu",
      ps[i], qs[i], rsa->keys.d, rsa->keys.n, rsa->keys.e);
  }
  CapyRSACipherFree(&rsa);
}

CUTEST(test002, "Ciphering/deciphering (1)") {
  uint64_t const p = 61;
  uint64_t const q = 53;
  CapyRSACipher* rsa = CapyRSACipherAlloc();
  $(rsa, generateKeys)(p, q);
  char const* const message = "Hello world!";
  size_t const len = strlen(message);
  uint64_t cipheredMessage[len];
  uint8_t decipheredMessage[len];
  bool isOk = true;
  loop(i, len) {
    cipheredMessage[i] = $(rsa, cipher)((uint64_t)(message[i]));
    decipheredMessage[i] = (uint8_t)$(rsa, decipher)(cipheredMessage[i]);
    isOk &= (decipheredMessage[i] == message[i]);
  }
  CUTEST_ASSERT(isOk, "ciphering/deciphering failed");
  CapyRSACipherFree(&rsa);
}

CUTEST(test003, "Ciphering/deciphering (2)") {
  uint64_t const p = 11922649;
  uint64_t const q = 74112287;
  CapyRSACipher* rsa = CapyRSACipherAlloc();
  $(rsa, generateKeys)(p, q);
  char const* const message = "Hello world!";
  size_t const len = strlen(message);
  uint64_t cipheredMessage[len];
  uint8_t decipheredMessage[len];
  bool isOk = true;
  loop(i, len) {
    cipheredMessage[i] = $(rsa, cipher)((uint64_t)(message[i]));
    decipheredMessage[i] = (uint8_t)$(rsa, decipher)(cipheredMessage[i]);
    isOk &= (decipheredMessage[i] == message[i]);
  }
  CUTEST_ASSERT(isOk, "ciphering/deciphering failed");
  CapyRSACipherFree(&rsa);
}

CUTEST(test004, "Ciphering/deciphering block (1)") {
  uint64_t const p = 61;
  uint64_t const q = 53;
  CapyRSACipher* rsa = CapyRSACipherAlloc();
  $(rsa, generateKeys)(p, q);
  char const* const str = "Hello world!";
  CapyRSACipherData message = {
    .data = (uint8_t*)str,
  };
  message.size = strlen(str);
  CapyRSACipherData cipheredMessage = $(rsa, cipherBlock)(message);
  CapyRSACipherData decipheredMessage = $(rsa, decipherBlock)(cipheredMessage);
  bool isOk = (memcmp(message.data, decipheredMessage.data, message.size) == 0);
  CUTEST_ASSERT(isOk, "ciphering/deciphering block failed");
  CapyRSACipherFree(&rsa);
  free(cipheredMessage.data);
  free(decipheredMessage.data);
}

CUTEST(test005, "Ciphering/deciphering block (2)") {
  uint64_t const p = 11922649;
  uint64_t const q = 74112287;
  CapyRSACipher* rsa = CapyRSACipherAlloc();
  $(rsa, generateKeys)(p, q);
  char const* const str = "Hello world!";
  CapyRSACipherData message = {
    .data = (uint8_t*)str,
  };
  message.size = strlen(str);
  CapyRSACipherData cipheredMessage = $(rsa, cipherBlock)(message);
  CapyRSACipherData decipheredMessage = $(rsa, decipherBlock)(cipheredMessage);
  bool isOk = (memcmp(message.data, decipheredMessage.data, message.size) == 0);
  CUTEST_ASSERT(isOk, "ciphering/deciphering block failed");
  CapyRSACipherFree(&rsa);
  free(cipheredMessage.data);
  free(decipheredMessage.data);
}

