#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Alloc and free a CapyRulerAndCompass instance") {
  CapyPoint2D pointA = {.coords = {0.0, 1.0}};
  CapyPoint2D pointB = {.coords = {2.0, 3.0}};
  CapyRulerAndCompass* rulerAndCompass =
    CapyRulerAndCompassAlloc(&pointA, &pointB);
  CapyRulerAndCompass* tmp = rulerAndCompass;
  CapyRulerAndCompassFree(&rulerAndCompass);
  CUTEST_ASSERT(
    tmp != NULL && rulerAndCompass == NULL,
    "Alloc or free failed");
}

CUTEST(test002, "Draw initial points (1)") {
  CapyPoint2D pointA = {.coords = {100.0, 200.0}};
  CapyPoint2D pointB = {.coords = {300.0, 200.0}};
  CapyRulerAndCompass* rulerAndCompass =
    CapyRulerAndCompassAlloc(&pointA, &pointB);
  CapyImg* img = CapyImgAlloc(capyImgMode_rgb, capyImgDims_400x400);
  rulerAndCompass->pen.color = capyColorRGBAWhite;
  $(rulerAndCompass, drawAll)(img);
  $(img, saveToPath)("UnitTests/TestRulerAndCompass/test001.png");
  CapyImg* check =
    CapyImgLoadFromPath("UnitTests/TestRulerAndCompass/check001.png");
  CUTEST_ASSERT($(img, isSame)(check), "draw failed");
  CapyImgFree(&check);
  CapyRulerAndCompassFree(&rulerAndCompass);
  CapyImgFree(&img);
}

CUTEST(test003, "Draw initial points (2)") {
  CapyPoint2D pointA = {.coords = {100.0, 200.0}};
  CapyPoint2D pointB = {.coords = {300.0, 200.0}};
  CapyRulerAndCompass* rulerAndCompass =
    CapyRulerAndCompassAlloc(&pointA, &pointB);
  CapyImg* img = CapyImgAlloc(capyImgMode_rgb, capyImgDims_400x400);
  rulerAndCompass->radiusPoint = 5.0;
  rulerAndCompass->pen.color = capyColorRGBAWhite;
  $(rulerAndCompass, drawAll)(img);
  $(img, saveToPath)("UnitTests/TestRulerAndCompass/test002.png");
  CapyImg* check =
    CapyImgLoadFromPath("UnitTests/TestRulerAndCompass/check002.png");
  CUTEST_ASSERT($(img, isSame)(check), "draw failed");
  CapyImgFree(&check);
  CapyRulerAndCompassFree(&rulerAndCompass);
  CapyImgFree(&img);
}

CUTEST(test004, "Add and draw segment from initial points") {
  CapyPoint2D pointA = {.coords = {100.0, 200.0}};
  CapyPoint2D pointB = {.coords = {300.0, 200.0}};
  CapyRulerAndCompass* rulerAndCompass =
    CapyRulerAndCompassAlloc(&pointA, &pointB);
  CapyImg* img = CapyImgAlloc(capyImgMode_rgb, capyImgDims_400x400);
  rulerAndCompass->radiusPoint = 5.0;
  rulerAndCompass->pen.color = capyColorRGBAWhite;
  $(rulerAndCompass, addSegment)("segment", "A", "B");
  $(rulerAndCompass, drawGeometry)(img, "segment");
  $(img, saveToPath)("UnitTests/TestRulerAndCompass/test003.png");
  CapyImg* check =
    CapyImgLoadFromPath("UnitTests/TestRulerAndCompass/check003.png");
  CUTEST_ASSERT($(img, isSame)(check), "draw failed");
  CapyImgFree(&check);
  CapyRulerAndCompassFree(&rulerAndCompass);
  CapyImgFree(&img);
}

CUTEST(test005, "Add and draw circle from initial points") {
  CapyPoint2D pointA = {.coords = {100.0, 200.0}};
  CapyPoint2D pointB = {.coords = {300.0, 200.0}};
  CapyRulerAndCompass* rulerAndCompass =
    CapyRulerAndCompassAlloc(&pointA, &pointB);
  CapyImg* img = CapyImgAlloc(capyImgMode_rgb, capyImgDims_400x400);
  rulerAndCompass->radiusPoint = 5.0;
  rulerAndCompass->pen.color = capyColorRGBAWhite;
  $(rulerAndCompass, addCircle)("circle", "A", "B");
  $(rulerAndCompass, drawGeometry)(img, "circle");
  $(img, saveToPath)("UnitTests/TestRulerAndCompass/test004.png");
  CapyImg* check =
    CapyImgLoadFromPath("UnitTests/TestRulerAndCompass/check004.png");
  CUTEST_ASSERT($(img, isSame)(check), "draw failed");
  CapyImgFree(&check);
  CapyRulerAndCompassFree(&rulerAndCompass);
  CapyImgFree(&img);
}

CUTEST(test006, "Add intersecting points") {
  CapyPoint2D pointA = {.coords = {200.0, 200.0}};
  CapyPoint2D pointB = {.coords = {300.0, 200.0}};
  CapyRulerAndCompass* rulerAndCompass =
    CapyRulerAndCompassAlloc(&pointA, &pointB);
  CapyImg* img = CapyImgAlloc(capyImgMode_rgb, capyImgDims_400x400);
  rulerAndCompass->radiusPoint = 5.0;
  rulerAndCompass->pen.color = capyColorRGBAWhite;
  $(rulerAndCompass, addSegment)("segment", "A", "B");
  $(rulerAndCompass, addCircle)("circle", "A", "B");
  $(rulerAndCompass, addPoint)("C", "D", "segment", "circle");
  $(rulerAndCompass, drawAll)(img);
  $(img, saveToPath)("UnitTests/TestRulerAndCompass/test005.png");
  CapyImg* check =
    CapyImgLoadFromPath("UnitTests/TestRulerAndCompass/check005.png");
  CUTEST_ASSERT($(img, isSame)(check), "draw failed");
  CapyImgFree(&check);
  CapyRulerAndCompassFree(&rulerAndCompass);
  CapyImgFree(&img);
}

CUTEST(test007, "Draw an hexagon") {
  CapyPoint2D pointA = {.coords = {200.0, 200.0}};
  CapyPoint2D pointB = {.coords = {300.0, 200.0}};
  CapyRulerAndCompass* rulerAndCompass =
    CapyRulerAndCompassAlloc(&pointA, &pointB);
  CapyImg* img = CapyImgAlloc(capyImgMode_rgb, capyImgDims_400x400);
  rulerAndCompass->radiusPoint = 5.0;
  $(rulerAndCompass, addSegment)("Se", "A", "B");
  $(rulerAndCompass, addCircle)("Ci", "A", "B");
  $(rulerAndCompass, addPoint)("C", "D", "Se", "Ci");
  $(rulerAndCompass, addCircle)("Ci1", "C", "A");
  $(rulerAndCompass, addPoint)("E", "F", "Ci", "Ci1");
  $(rulerAndCompass, addCircle)("Ci2", "E", "A");
  $(rulerAndCompass, addPoint)("G", "H", "Ci", "Ci2");
  $(rulerAndCompass, addCircle)("Ci3", "F", "A");
  $(rulerAndCompass, addPoint)("I", "J", "Ci", "Ci3");
  $(rulerAndCompass, addSegment)("Se1", "C", "E");
  $(rulerAndCompass, addSegment)("Se2", "C", "F");
  $(rulerAndCompass, addSegment)("Se3", "E", "G");
  $(rulerAndCompass, addSegment)("Se4", "F", "J");
  $(rulerAndCompass, addSegment)("Se5", "G", "B");
  $(rulerAndCompass, addSegment)("Se6", "J", "B");
  rulerAndCompass->pen.color = (CapyColorData){.rgb = {0.5, 0.5, 0.5}};
  $(rulerAndCompass, drawAll)(img);
  rulerAndCompass->pen.color = capyColorRGBAWhite;
  $(rulerAndCompass, drawGeometry)(img, "Se1");
  $(rulerAndCompass, drawGeometry)(img, "Se2");
  $(rulerAndCompass, drawGeometry)(img, "Se3");
  $(rulerAndCompass, drawGeometry)(img, "Se4");
  $(rulerAndCompass, drawGeometry)(img, "Se5");
  $(rulerAndCompass, drawGeometry)(img, "Se6");
  $(img, saveToPath)("UnitTests/TestRulerAndCompass/test006.png");
  CapyImg* check =
    CapyImgLoadFromPath("UnitTests/TestRulerAndCompass/check006.png");
  CUTEST_ASSERT($(img, isSame)(check), "draw failed");
  CapyImgFree(&check);
  CapyRulerAndCompassFree(&rulerAndCompass);
  CapyImgFree(&img);
}

CUTEST(test008, "Create an arc") {
  CapyPoint2D pointA = {.coords = {150.0, 200.0}};
  CapyPoint2D pointB = {.coords = {250.0, 200.0}};
  CapyRulerAndCompass* rulerAndCompass =
    CapyRulerAndCompassAlloc(&pointA, &pointB);
  CapyImg* img = CapyImgAlloc(capyImgMode_rgb, capyImgDims_400x400);
  rulerAndCompass->radiusPoint = 5.0;
  rulerAndCompass->pen.color = capyColorRGBAWhite;
  $(rulerAndCompass, addCircle)("circleA", "A", "B");
  $(rulerAndCompass, addCircle)("circleB", "B", "A");
  $(rulerAndCompass, addPoint)("C", "D", "circleA", "circleB");
  $(rulerAndCompass, drawArc)(img, "circleA", "D", "C");
  $(rulerAndCompass, drawArc)(img, "circleB", "C", "D");
  $(img, saveToPath)("UnitTests/TestRulerAndCompass/test007.png");
  CapyImg* check =
    CapyImgLoadFromPath("UnitTests/TestRulerAndCompass/check007.png");
  CUTEST_ASSERT($(img, isSame)(check), "draw failed");
  CapyImgFree(&check);
  CapyRulerAndCompassFree(&rulerAndCompass);
  CapyImgFree(&img);
}

