#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Sliding average") {
  CapySlidingAverage* avg = CapySlidingAverageAlloc(3);
  double check[] = {
    1.0, 1.5, 2.0, 2.6666, 3.4444, 4.2962, 5.1975, 6.1316, 7.0877, 8.0585
  };
  loop(i, 10) {
    $(avg, update)(i + 1);
    CUTEST_ASSERT(
      fabs(avg->val - check[i]) < 0.0001,
      "unexpected value [%d]=%lf != %lf",
      i, avg->val, check[i]);
  }
  CapySlidingAverageFree(&avg);
}
