#include "capy.h"
#ifndef FIXTURE
#define FIXTURE

// Dummy structure
typedef struct Dummy {
  uint8_t a, b;
  CapyPad(uint8_t[2], 0);
  size_t nb;
} Dummy;

// Test function
static int Eval(
  void const* a,
  void const* b) {
  Dummy const* c = a;
  Dummy const* d = b;
  return (
    (c->a + c->b) > (d->a + d->b) ? 1 :
    (c->a + c->b) < (d->a + d->b) ? -1 :0);
}

#endif
CUTEST(test001, "QuickSort") {
  #define nbElemMax 1000
  Dummy array[nbElemMax];
  CapyRandom rnd = CapyRandomCreate(0);
  loop(iTry, 1000) {
    CapyRangeInt64 range = {.min = 1, .max = nbElemMax-1};
    size_t nbElem = (size_t)($(&rnd, getInt64Range)(&range));
    loop(i, nbElem) {
      array[i] = (Dummy){
        $(&rnd, getUInt8)(),
        $(&rnd, getUInt8)(),
        {0},
        nbElem
      };
    }
    CapyComparator cmp = {.eval = Eval};
    CapyQuickSort(array, sizeof(Dummy), nbElem, &cmp);
    loop(i, nbElem - 1) {
      int eval = Eval(array + i, array + i + 1);
      CUTEST_ASSERT(eval <= 0, "QuickSort failed");
    }
  }
  $(&rnd, destruct)();
}
