#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "StreamIo operations (1)") {
  FILE* f = fopen("UnitTests/TestStreamIo/streamio.txt", "w");
  fprintf(f, "123\n456\n789\n");
  fclose(f);
  CapyStreamIo* stream = CapyStreamIoAlloc();
  bool ret = $(stream, isOpened)();
  CUTEST_ASSERT(ret == false, "initialisation failed");
  $(stream, open)("UnitTests/TestStreamIo/streamio.txt", "r");
  size_t size = $(stream, getSize)();
  CUTEST_ASSERT(size == 12, "unexpected size %lu", size);
  ret = $(stream, isOpened)();
  CUTEST_ASSERT(ret, "open failed");
  int cmp = strcmp(stream->pathname, "UnitTests/TestStreamIo/streamio.txt");
  CUTEST_ASSERT(cmp == 0, "pathname invalid %s", stream->pathname);
  CapyListArrChar* lines = $(stream, readLines)();
  size = $(lines, getSize)();
  CUTEST_ASSERT(size == 3, "invalid size %lu", size);
  char const* checkLines[] = {"123", "456", "789", "abc"};
  loop(i, (size_t)3) {
    char* line = $(lines, get)(i).data;
    cmp = strcmp(checkLines[i], line);
    CUTEST_ASSERT(
      cmp == 0,
      "readLines failed [%lu]=%s != %s", i, line, checkLines[i]);
  }
  while($(lines, getSize)() > 0) {
    CapyArrChar line = $(lines, pop)();
    $(&line, destruct)();
  }
  CapyListArrCharFree(&lines);
  $(stream, close)();
  ret = $(stream, isOpened)();
  CUTEST_ASSERT(ret == false, "close failed");
  CUTEST_ASSERT(stream->pathname == NULL, "close failed");
  CUTEST_ASSERT(stream->stream == NULL, "close failed");
  CapyStreamIoFree(&stream);
  CUTEST_ASSERT(stream == NULL, "stream not reset");
  f = fopen("UnitTests/TestStreamIo/streamio.txt", "w");
  fprintf(f, "123\n456\n789\nabc");
  fclose(f);
  stream = CapyStreamIoAlloc();
  $(stream, open)("UnitTests/TestStreamIo/streamio.txt", "r");
  lines = $(stream, readLines)();
  size = $(lines, getSize)();
  CUTEST_ASSERT(size == 4, "readLines failed %lu", size);
  loop(i, (size_t)4) {
    char* line = $(lines, get)(i).data;
    cmp = strcmp(checkLines[i], line);
    CUTEST_ASSERT(
      cmp == 0,
      "readLines failed [%lu]=%s != %s", i, line, checkLines[i]);
  }
  $(stream, close)();
  CapyStreamIoFree(&stream);
  stream = CapyStreamIoAlloc();
  $(stream, open)("UnitTests/TestStreamIo/streamio.txt", "w");
  $(stream, writeLines)(lines);
  $(stream, close)();
  CapyStreamIoFree(&stream);
  while($(lines, getSize)() > 0) {
    CapyArrChar line = $(lines, pop)();
    $(&line, destruct)();
  }
  CapyListArrCharFree(&lines);
  stream = CapyStreamIoAlloc();
  $(stream, open)("UnitTests/TestStreamIo/streamio.txt", "r");
  lines = $(stream, readLines)();
  size = $(lines, getSize)();
  CUTEST_ASSERT(size == 4, "readLines failed %lu", size);
  loop(i, (size_t)4) {
    char* line = $(lines, get)(i).data;
    cmp = strcmp(checkLines[i], line);
    CUTEST_ASSERT(
      cmp == 0,
      "readLines failed [%lu]=%s != %s", i, line, checkLines[i]);
  }
  while($(lines, getSize)() > 0) {
    CapyArrChar line = $(lines, pop)();
    $(&line, destruct)();
  }
  CapyListArrCharFree(&lines);
  CapyStreamIoFree(&stream);
}

CUTEST(test002, "StreamIo operations (2)") {
  FILE* f = fopen("UnitTests/TestStreamIo/streamio.txt", "w");
  fprintf(f, "123\n456\n789\n");
  fclose(f);
  CapyStreamIo* stream = CapyStreamIoAlloc();
  $(stream, open)("UnitTests/TestStreamIo/streamio.txt", "rb");
  CapyArrChar* data = $(stream, read)();
  size_t size = $(data, getSize)();
  CUTEST_ASSERT(size == 12, "unexpected size %lu", size);
  int cmp = memcmp("123\n456\n789\n", data->data, 12);
  CUTEST_ASSERT(cmp == 0, "read failed %12s", data->data);
  CapyStreamIoFree(&stream);
  stream = CapyStreamIoAlloc();
  $(stream, open)("UnitTests/TestStreamIo/streamio.txt", "rb");
  char bytes[2];
  $(stream, readBytes)(bytes, 2);
  CUTEST_ASSERT(bytes[0] == '1', "readBytes failed %d", bytes[0]);
  CUTEST_ASSERT(bytes[1] == '2', "readBytes failed %d", bytes[1]);
  CapyStreamIoFree(&stream);
  stream = CapyStreamIoAlloc();
  $(stream, open)("UnitTests/TestStreamIo/streamio.txt", "wb");
  $(stream, write)(data);
  CapyStreamIoFree(&stream);
  CapyArrCharFree(&data);
  stream = CapyStreamIoAlloc();
  $(stream, open)("UnitTests/TestStreamIo/streamio.txt", "rb");
  data = $(stream, read)();
  size = $(data, getSize)();
  CUTEST_ASSERT(size == 12, "unexpected size %lu", size);
  cmp = memcmp("123\n456\n789\n", data->data, 12);
  CUTEST_ASSERT(cmp == 0, "read failed %12s", data->data);
  CapyStreamIoFree(&stream);
  CapyArrCharFree(&data);
  stream = CapyStreamIoAlloc();
  $(stream, open)("UnitTests/TestStreamIo/streamio.txt", "wb");
  $(stream, writeBytes)(bytes, 2);
  CapyStreamIoFree(&stream);
  stream = CapyStreamIoAlloc();
  $(stream, open)("UnitTests/TestStreamIo/streamio.txt", "rb");
  data = $(stream, read)();
  size = $(data, getSize)();
  CUTEST_ASSERT(size == 2, "unexpected size %lu", size);
  cmp = memcmp("12", data->data, 2);
  CUTEST_ASSERT(cmp == 0, "read failed %2s", data->data);
  CapyStreamIoFree(&stream);
  CapyArrCharFree(&data);
}
