#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "iris dataset (minMaxNormalization)") {
  CapyDataset* dataset = CapyDatasetAlloc();
  char const* pathDataset = "Resources/iris.csv";
  $(dataset, loadFromPath)(pathDataset);
  CapySupportVectorMachine* svm = CapySupportVectorMachineAlloc();
  CapySVMKernelGaussian kernel = CapySVMKernelGaussianCreate();
  kernel.gamma = 10.0;
  $(svm, setKernel)((CapySVMKernel*)&kernel);
  svm->coeffRelax = 100.0;
  svm->verbose = false;
  svm->seed = 0;
  svm->featureScaling = capyPredictorFeatureScaling_minMaxNormalization;
  $(svm, train)(dataset);
  CapyPredictorEvaluation* eval = $(svm, evaluate)(dataset);
  CUTEST_ASSERT(
    svm->support.nbRow == 16,
    "unexpected number of support vectors %lu", svm->support.nbRow);
  CUTEST_ASSERT(
    fabs(
      eval->accuracies[capyPredictorAccuracyMeasure_accuracy] -
      0.666667) < 1e-4,
    "train failed %lf",
    eval->accuracies[capyPredictorAccuracyMeasure_accuracy]);
  FILE* stream = fopen("UnitTests/TestSupportVectorMachine/iris.c", "w");
  $(svm, exportToCFun)(stream, "IrisPred", dataset);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestSupportVectorMachine/iris.c "
      "UnitTests/TestSupportVectorMachine/iris_check.c >"
      "UnitTests/TestSupportVectorMachine/iris_diff.txt") == 0,
    "exportToCFun failed");
  stream = fopen("UnitTests/TestSupportVectorMachine/iris.html", "w");
  $(svm, exportToHtml)(
    stream, "Iris species prediction",
    dataset, eval->accuracies[capyPredictorAccuracyMeasure_accuracy]);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestSupportVectorMachine/iris.html "
      "UnitTests/TestSupportVectorMachine/iris_check.html >"
      "UnitTests/TestSupportVectorMachine/iris_diff.txt") == 0,
    "exportToCFun failed");
  CapySupportVectorMachineFree(&svm);
  $(&kernel, destruct)();
  CapyPredictorEvaluationFree(&eval);
  CapyDatasetFree(&dataset);
}

CUTEST(test002, "iris dataset (minMaxNormalizationSym)") {
  CapyDataset* dataset = CapyDatasetAlloc();
  char const* pathDataset = "Resources/iris.csv";
  $(dataset, loadFromPath)(pathDataset);
  CapySupportVectorMachine* svm = CapySupportVectorMachineAlloc();
  CapySVMKernelGaussian kernel = CapySVMKernelGaussianCreate();
  kernel.gamma = 10.0;
  $(svm, setKernel)((CapySVMKernel*)&kernel);
  svm->coeffRelax = 100.0;
  svm->verbose = false;
  svm->seed = 0;
  svm->featureScaling = capyPredictorFeatureScaling_minMaxNormalizationSym;
  $(svm, train)(dataset);
  CapyPredictorEvaluation* eval = $(svm, evaluate)(dataset);
  CUTEST_ASSERT(
    svm->support.nbRow == 69,
    "unexpected number of support vectors %lu", svm->support.nbRow);
  CUTEST_ASSERT(
    fabs(
      eval->accuracies[capyPredictorAccuracyMeasure_accuracy] -
      0.666667) < 1e-4,
    "train failed %lf",
    eval->accuracies[capyPredictorAccuracyMeasure_accuracy]);
  FILE* stream = fopen(
    "UnitTests/TestSupportVectorMachine/iris_center_scale.c", "w");
  $(svm, exportToCFun)(stream, "IrisPred", dataset);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestSupportVectorMachine/iris_center_scale.c "
      "UnitTests/TestSupportVectorMachine/iris_center_scale_check.c >"
      "UnitTests/TestSupportVectorMachine/iris_diff.txt") == 0,
    "exportToCFun failed");
  stream = fopen(
    "UnitTests/TestSupportVectorMachine/iris_center_scale.html", "w");
  $(svm, exportToHtml)(
    stream, "Iris species prediction",
    dataset, eval->accuracies[capyPredictorAccuracyMeasure_accuracy]);
  fclose(stream);
  CUTEST_ASSERT(
    system(
      "diff UnitTests/TestSupportVectorMachine/iris_center_scale.html "
      "UnitTests/TestSupportVectorMachine/iris_center_scale_check.html >"
      "UnitTests/TestSupportVectorMachine/iris_diff.txt") == 0,
    "exportToCFun failed");
  CapySupportVectorMachineFree(&svm);
  $(&kernel, destruct)();
  CapyPredictorEvaluationFree(&eval);
  CapyDatasetFree(&dataset);
}
