#include "capy.h"
#ifndef FIXTURE
#define FIXTURE

// Dummy structure
typedef struct Dummy {
  uint8_t a;
  CapyPad(uint8_t, a);
  void (*destruct)(void);
} Dummy;

CapyDecTree(TreeDummy, Dummy)
CapyDefTree(TreeDummy, Dummy)
#endif
CUTEST(test001, "Creation/destruction of a generic tree") {
  Dummy dummy = {.a = 1};
  TreeDummy* tree = TreeDummyAlloc(&dummy);
  CUTEST_ASSERT(tree, "tree unallocated");
  TreeDummyFree(&tree);
  CUTEST_ASSERT(tree == false, "tree not reset to null");
}

CUTEST(test002, "Set/Get data") {
  Dummy dummy = {.a = 1};
  TreeDummy* tree = TreeDummyAlloc(&dummy);
  dummy.a = 2;
  $(tree, setData)(&dummy);
  CUTEST_ASSERT(
    memcmp(&dummy, &(tree->data), sizeof(Dummy)) == 0, "setData failed");
  Dummy d = $(tree, getData)();
  CUTEST_ASSERT(memcmp(&dummy, &d, sizeof(Dummy)) == 0, "getData failed");
  Dummy* dPtr = $(tree, getDataPtr)();
  CUTEST_ASSERT(dPtr == &(tree->data), "getDataPtr failed");
  TreeDummyFree(&tree);
}

CUTEST(test003, "Add/Get brother") {
  Dummy dummy = {.a = 1};
  TreeDummy* tree = TreeDummyAlloc(&dummy);
  dummy.a = 2;
  TreeDummy* brother = $(tree, addBrother)(&dummy);
  CUTEST_ASSERT(
    tree->brother != NULL &&
    tree->brother == brother &&
    memcmp(&dummy, &(brother->data), sizeof(Dummy)) == 0,
    "addBrother failed");
  TreeDummy* brotherPtr = $(tree, getNextBrother)();
  CUTEST_ASSERT(brotherPtr == tree->brother, "getNextBrother failed");
  dummy.a = 3;
  TreeDummy* anotherBrother = $(tree, addBrother)(&dummy);
  CUTEST_ASSERT(brotherPtr->brother == anotherBrother, "addBrother failed");
  CUTEST_ASSERT(
    tree->brother != NULL &&
    tree->brother == brother &&
    brother->brother != NULL &&
    brother->brother == anotherBrother &&
    memcmp(&dummy, &(anotherBrother->data), sizeof(Dummy)) == 0,
    "addBrother failed");
  TreeDummyFree(&tree);
}

CUTEST(test004, "Add/Get child") {
  Dummy dummy = {.a = 1};
  TreeDummy* tree = TreeDummyAlloc(&dummy);
  dummy.a = 2;
  TreeDummy* child = $(tree, addChild)(&dummy);
  CUTEST_ASSERT(
    tree->child != NULL &&
    tree->child == child &&
    memcmp(&dummy, &(child->data), sizeof(Dummy)) == 0,
    "addChild failed");
  TreeDummy* childPtr = $(tree, getFirstChild)();
  CUTEST_ASSERT(childPtr == tree->child, "getFirstChild failed");
  dummy.a = 3;
  TreeDummy* childBrother = $(tree, addChild)(&dummy);
  CUTEST_ASSERT(tree->child == childPtr, "addChild failed");
  CUTEST_ASSERT(
    childPtr->brother != NULL &&
    childPtr->brother == childBrother &&
    memcmp(&dummy, &(childBrother->data), sizeof(Dummy)) == 0,
    "addChild failed");
  TreeDummyFree(&tree);
}

CUTEST(test005, "Iterator breadth first") {
  Dummy dummy = {.a = 1};
  TreeDummy* tree = TreeDummyAlloc(&dummy);
  dummy.a = 2;
  TreeDummy* child = $(tree, addChild)(&dummy);
  dummy.a = 3;
  (void)$(child, addBrother)(&dummy);
  dummy.a = 4;
  (void)$(child, addChild)(&dummy);
  forEach(d, tree->iter) {
    CUTEST_ASSERT(
      d.a == tree->iter.idx + 1,
      "d.a=%d, tree->iter.idx=%lu", d.a, tree->iter.idx);
  }
  TreeDummyFree(&tree);
}

CUTEST(test006, "Iterator depth first") {
  Dummy dummy = {.a = 1};
  TreeDummy* tree = TreeDummyAlloc(&dummy);
  dummy.a = 2;
  TreeDummy* child = $(tree, addChild)(&dummy);
  dummy.a = 4;
  (void)$(child, addBrother)(&dummy);
  dummy.a = 3;
  (void)$(child, addChild)(&dummy);
  $(&(tree->iter), setType)(capyTreeIteratorType_depthFirst);
  forEach(d, tree->iter) {
    CUTEST_ASSERT(
      d.a == tree->iter.idx + 1,
      "d.a=%d, tree->iter.idx=%lu", d.a, tree->iter.idx);
  }
  TreeDummyFree(&tree);
}

CUTEST(test007, "Get nb leaves") {
  Dummy dummy = {.a = 1};
  TreeDummy* tree = TreeDummyAlloc(&dummy);
  dummy.a = 2;
  TreeDummy* child = $(tree, addChild)(&dummy);
  dummy.a = 3;
  (void)$(child, addBrother)(&dummy);
  dummy.a = 4;
  (void)$(child, addChild)(&dummy);
  size_t const nbLeaf = $(tree, getNbLeaf)();
  CUTEST_ASSERT(nbLeaf == 2, "nbLeaf=%lu", nbLeaf);
  TreeDummyFree(&tree);
}
