#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
static void ProjectileDerivative(
  double const* const in,
        double* const out) {
  double const M = 1.0;
  double const g = 9.8;
  out[0] = 0.0;
  out[1] = -M * g;
}

#endif
CUTEST(test001, "Projectile, step") {
  CapyMathFun derivative = CapyMathFunCreate(5, 2);
  derivative.eval = ProjectileDerivative;
  CapyVerletIntegration* verlet = CapyVerletIntegrationAlloc(&derivative);
  verlet->deltaT = 0.01;
  verlet->initVal.vals[1] = 0.0;
  verlet->initVal.vals[2] = 0.0;
  verlet->initVal.vals[3] = 1.0;
  verlet->initVal.vals[4] = 1.0;
  bool isOk = true;
  loop(i, 100) {
    $(verlet, step)(verlet->initVal.vals);
  }
  isOk &=
    (fabs(verlet->initVal.vals[1] - 1.0) < 1e-6) &&
    (fabs(verlet->initVal.vals[2] + 3.9) < 1e-6) &&
    (fabs(verlet->initVal.vals[3] - 1.0) < 1e-6) &&
    (fabs(verlet->initVal.vals[4] + 8.8) < 1e-6);
  CUTEST_ASSERT(isOk, "isOk=%d\n", isOk);
  CapyVerletIntegrationFree(&verlet);
  $(&derivative, destruct)();
}
