#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Ranked choice voting (1)") {
  size_t const nbVoter = 5;
  uint8_t const nbChoice = 3;
  uint8_t rankings[5][3] = {
    {0, 1, 2},
    {0, 2, 1},
    {1, 0, 2},
    {2, 1, 0},
    {1, 0, 2},
  };
  CapyRankedChoiceVoting* voting =
    CapyRankedChoiceVotingAlloc(nbChoice, nbVoter);
  loop(iVoter, nbVoter) loop(iRanking, nbChoice) {
    $(voting, setRanking)(
      (size_t)iVoter, (uint8_t)iRanking, rankings[iVoter][iRanking]);
  }
  CapyRankedChoiceVotingResult result = $(voting, getResult)();
  CUTEST_ASSERT(
    result.nbVotes[0] == 2 &&
    result.nbVotes[1] == 3 &&
    result.nbVotes[2] == 1 &&
    voting->votes[0].choice == 0 &&
    voting->votes[1].choice == 0 &&
    voting->votes[2].choice == 0 &&
    voting->votes[3].choice == 1 &&
    voting->votes[4].choice == 0,
    "result.nbVotes[0] = %lu, result.nbVotes[1] = %lu, "
    "result.nbVotes[2] = %lu, "
    "voting->votes[0].choice = %u, voting->votes[1].choice = %u, "
    "voting->votes[2].choice = %u, voting->votes[3].choice = %u, "
    "voting->votes[4].choice = %u",
    result.nbVotes[0], result.nbVotes[1], result.nbVotes[2],
    voting->votes[0].choice, voting->votes[1].choice, voting->votes[2].choice,
    voting->votes[3].choice, voting->votes[4].choice);
  CapyRankedChoiceVotingFree(&voting);
}

CUTEST(test002, "Ranked choice voting (2)") {
  size_t const nbVoter = 4;
  uint8_t const nbChoice = 3;
  uint8_t rankings[4][3] = {
    {0, 1, 2},
    {0, 2, 1},
    {1, 2, 0},
    {2, 1, 0},
  };
  CapyRankedChoiceVoting* voting =
    CapyRankedChoiceVotingAlloc(nbChoice, nbVoter);
  loop(iVoter, nbVoter) loop(iRanking, nbChoice) {
    $(voting, setRanking)(
      (size_t)iVoter, (uint8_t)iRanking, rankings[iVoter][iRanking]);
  }
  CapyRankedChoiceVotingResult result = $(voting, getResult)();
  CUTEST_ASSERT(
    result.nbVotes[0] == 2 &&
    result.nbVotes[1] == 1 &&
    result.nbVotes[2] == 1 &&
    voting->votes[0].choice == 0 &&
    voting->votes[1].choice == 0 &&
    voting->votes[2].choice == 0 &&
    voting->votes[3].choice == 0,
    "result.nbVotes[0] = %lu, result.nbVotes[1] = %lu, "
    "result.nbVotes[2] = %lu, "
    "voting->votes[0].choice = %u, voting->votes[1].choice = %u, "
    "voting->votes[2].choice = %u, voting->votes[3].choice = %u",
    result.nbVotes[0], result.nbVotes[1], result.nbVotes[2],
    voting->votes[0].choice, voting->votes[1].choice, voting->votes[2].choice,
    voting->votes[3].choice);
  CapyRankedChoiceVotingFree(&voting);
}

CUTEST(test003, "Ranked choice voting (3)") {
  size_t const nbVoter = 4;
  uint8_t const nbChoice = 3;
  uint8_t rankings[4][3] = {
    {0, 1, 2},
    {0, 2, 1},
    {0, 2, 1},
    {0, 1, 2},
  };
  CapyRankedChoiceVoting* voting =
    CapyRankedChoiceVotingAlloc(nbChoice, nbVoter);
  loop(iVoter, nbVoter) loop(iRanking, nbChoice) {
    $(voting, setRanking)(
      (size_t)iVoter, (uint8_t)iRanking, rankings[iVoter][iRanking]);
  }
  CapyRankedChoiceVotingResult result = $(voting, getResult)();
  CUTEST_ASSERT(
    result.nbVotes[0] == 4 &&
    result.nbVotes[1] == 0 &&
    result.nbVotes[2] == 0 &&
    voting->votes[0].choice == 0 &&
    voting->votes[1].choice == 0 &&
    voting->votes[2].choice == 0 &&
    voting->votes[3].choice == 0,
    "result.nbVotes[0] = %lu, result.nbVotes[1] = %lu, "
    "result.nbVotes[2] = %lu, "
    "voting->votes[0].choice = %u, voting->votes[1].choice = %u, "
    "voting->votes[2].choice = %u, voting->votes[3].choice = %u",
    result.nbVotes[0], result.nbVotes[1], result.nbVotes[2],
    voting->votes[0].choice, voting->votes[1].choice, voting->votes[2].choice,
    voting->votes[3].choice);
  CapyRankedChoiceVotingFree(&voting);
}

CUTEST(test004, "Ranked choice voting (4)") {
  size_t const nbVoter = 6;
  uint8_t const nbChoice = 3;
  uint8_t rankings[6][3] = {
    {0, 1, 2},
    {0, 2, 1},
    {2, 0, 1},
    {2, 1, 0},
    {1, 0, 2},
    {1, 0, 2},
  };
  CapyRankedChoiceVoting* voting =
    CapyRankedChoiceVotingAlloc(nbChoice, nbVoter);
  loop(iVoter, nbVoter) loop(iRanking, nbChoice) {
    $(voting, setRanking)(
      (size_t)iVoter, (uint8_t)iRanking, rankings[iVoter][iRanking]);
  }
  CapyRankedChoiceVotingResult result = $(voting, getResult)();
  CUTEST_ASSERT(
    result.nbVotes[0] == 2 &&
    result.nbVotes[1] == 2 &&
    result.nbVotes[2] == 2 &&
    voting->votes[0].choice == 0 &&
    voting->votes[1].choice == 0 &&
    voting->votes[2].choice == 0 &&
    voting->votes[3].choice == 0 &&
    voting->votes[4].choice == 0,
    "result.nbVotes[0] = %lu, result.nbVotes[1] = %lu, "
    "result.nbVotes[2] = %lu, "
    "voting->votes[0].choice = %u, voting->votes[1].choice = %u, "
    "voting->votes[2].choice = %u, voting->votes[3].choice = %u, "
    "voting->votes[4].choice = %u",
    result.nbVotes[0], result.nbVotes[1], result.nbVotes[2],
    voting->votes[0].choice, voting->votes[1].choice, voting->votes[2].choice,
    voting->votes[3].choice, voting->votes[4].choice);
  CapyRankedChoiceVotingFree(&voting);
}
