#include "capy.h"
#ifndef FIXTURE
#define FIXTURE
#endif
CUTEST(test001, "Screenshot") {
  CapyX11Display* display =
    CapyX11DisplayAlloc(300, 300, NULL, "title");
  CapyX11DisplayBuffer buffer = CapyX11DisplayGetBuffer(display);
  CapyX11RGB rgb = {.vals = {125, 125, 125}};
  CapyBezier bezier = CapyBezierCreate(2, 1, 2);
  double vals[3][2] = {{50, 50}, {150, 150}, {250, 50}};
  loop(i, (size_t)3) $(&bezier, setCtrl)(&i, vals[i]);
  $(&buffer, drawBezier)(&bezier, &rgb);
  CapyImg* img = $(&buffer, toImg)();
  $(img, saveToPath)("UnitTests/TestX11Display/screenshot.png");
  CapyImg* checkImg =
    CapyImgLoadFromPath("UnitTests/TestX11Display/checkScreenshot.png");
  CUTEST_ASSERT(
    $(img, isSame)(checkImg),
    "UnitTests/TestX11Display/screenshot.png differs from "
    "UnitTests/TestX11Display/checkScreenshot.png");
  CapyImgFree(&checkImg);
  CapyImgFree(&img);
  CapyX11DisplayFree(&display);
  $(&bezier, destruct)();
}

CUTEST(test002, "DrawCircle") {
  CapyX11Display* display =
    CapyX11DisplayAlloc(300, 300, NULL, "title");
  CapyX11DisplayBuffer buffer = CapyX11DisplayGetBuffer(display);
  CapyX11RGB rgb = {.vals = { 255, 255, 255}};
  CapyCircle circle = {.center.coords = {150, 150}, .radius = 140};
  $(&buffer, drawCircle)(&circle, &rgb);
  CapyImg* img = $(&buffer, toImg)();
  $(img, saveToPath)("UnitTests/TestX11Display/circle.png");
  CapyImg* checkImg =
    CapyImgLoadFromPath("UnitTests/TestX11Display/checkCircle.png");
  CUTEST_ASSERT(
    $(img, isSame)(checkImg),
    "UnitTests/TestX11Display/circle.png differs from "
    "UnitTests/TestX11Display/checkCircle.png");
  CapyImgFree(&checkImg);
  CapyImgFree(&img);
  CapyX11DisplayFree(&display);
}

CUTEST(test003, "DrawSegment") {
  CapyX11Display* display =
    CapyX11DisplayAlloc(300, 300, NULL, "title");
  CapyX11DisplayBuffer buffer = CapyX11DisplayGetBuffer(display);
  CapyX11RGB rgb = {.vals = { 255, 255, 255}};
  CapySegment seg =
    { .points = {{.coords = {50, 50}}, { .coords = {200, 250}}}};
  $(&buffer, drawLine)(&seg, &rgb);
  CapyImg* img = $(&buffer, toImg)();
  $(img, saveToPath)("UnitTests/TestX11Display/segment.png");
  CapyImg* checkImg =
    CapyImgLoadFromPath("UnitTests/TestX11Display/checkSegment.png");
  CUTEST_ASSERT(
    $(img, isSame)(checkImg),
    "UnitTests/TestX11Display/segment.png differs from "
    "UnitTests/TestX11Display/checkSegment.png");
  CapyImgFree(&checkImg);
  CapyImgFree(&img);
  CapyX11DisplayFree(&display);
}
