# Versions

This file contains the list of the versions of LibCapy and the detail of the new features in each one.

## v0.1

* Standard functions extended with exception management: safeMalloc, safeRealloc, safeFOpen, safeSPrintf, safeFPrintf, safeFScanf, safeFRead, safeFWrite
* min/max on arrays of basic types
* loop(shortcut of `for` loop) and forEach(iteration using iterators defined by LibCapy)
* println/fprintln (printf/fprintf with a line return)
* $ and $$ (operator for OOP methods)
* CapyInherits macro for class inheritance
* equal (equality operator on floating point values using the ULP method)
* CapyGetVersion, CapyGetCommitId, CapyGetBuildMode (infos about the library)
* Exception management framework.
* Color, RGB/RGBA/HSV/greyscale modes. Conversion between RGB and HSV.
* Decoration of output to the CLI using escape sequences.
* Generic arrays, fixed size and resizable. Iterators (forward/backward) on these generic arrays.
* Generic double linked lists. Iterators (forward/backward) on these generic lists.
* PNG image, load/save, access/edit pixels. Iterator on the pixels.
* Display in a GTK window of an image in a separate process. Interaction via keyboard. Automatic refresh of the window content when the image is edited.
* Command line argument parser.
* I/O Stream, load and save a text file content line by line, load and save the content of a file all at once.
* Feistel cipher network, available operation modes are ECB, CBC, CTR.
* Vector, vector of double values for numeric calculation, generic definition for any size; functions: add
* Range, range of numerical value; functions: trim

## v0.2

* Elo ranking system.
* Random, pseudo random generator based on 64 bits xorshift, squirrel3 and the Downey's algorithm. Generation of integer, rational and real numbers within an interval.
* Math, mathematical functions and algorithms. Functions: greatest common divisor using Stein's algorithm; Russian peasant multiplication of positive integers to calculate a*b and a*b/c; smooth step function with controllable slope; power function for integer variables; LERP.
* ArgParser. Modif the return type of getAsInt from int16_t to int64_t
* StreamIO, add isOpened, readBytes, writeBytes
* Dict, dictionaries with char* key and generic value. Iterators on the dictionaries' entries.
* Ratio, rational number implementation. Addition, negation, substraction, multiplication, inverse, division, absolute value, comparison, reduction, conversion from/to double, raising to an integer power, square root.
* Image. Set the color of a pixel; create a clone; copy an image into another; change the gamma encoding; find the brightest pixel.
* Generic arrays. Shuffle.
* loopRange (shortcut of `for` loop on a CapyRange).
* MathFun. Abstract class to be inherited by other objects implementing mathematical functions.
* Bezier. Bezier curve/surface of any order/nb input/nb output.
* Pen. Tool to draw point and CapyBezier on a CapyImg. Color, hardness, size; draw point, line, Bezier.
* Display. Change the window's title during execution; get time in milliseconds since shown; handlers for onShow and onClose events; magnify to fit in an image; current mouse position in display and image coordinates; interaction via the mouse.
* DiffEvo (Optimizer using the differential evolution method). Run in a separate process.
* CapyColorChart. Color chart for image color correction; QP203 color chart data; extraction of a color chart from an image; brightness matching between two charts; load/save to a file.
* CapyColorCorrMat. Color correction matrix; calculation of the matrix matching to color chart; application of the correction matrix to an image; load/save to a file.
* CapyColorHisto. Color histograms. Extract the histograms from an image; apply the histogram to an image.

Issues solved:
* &#35;1 Invalid free at the end of CapyDisplay.show when the display has been created with CapyDisplayCreate()
* &#35;2 The size of the generic arrays when reallocating is improperly calculated (sizeof(type) missing)
* &#35;3 The size of the allocation in CapyDisplayMagnifierAlloc is erroneous
* &#35;4 Remove the functions CapyVec*Add()
* &#35;5 CapyArr.getPtr return the wrong adress. Multiplication by the size of data is missing.

## v0.3

* Comparator. Object to compare data (for example to sort them).
* Sort. Sorting algorithms. QuickSort.
* Generic arrays. QSort.
* DistributionContinuous. Generic class to implement probability distribution for continuous random variables.
* NormalDistribution.
* ImgKernel. Kernels for image processing. GaussianBlur; DerivativeGaussianBlur.
* Color, XYZ/LAB modes. Conversions RGB<->XYZ, XYZ<->LAB, RGB->rgb, RGB->l1l2l3, RGB->c1c2c3.
* Image. Conversion to greyscale, black/white, hsv, normalised rgb, l1l2l3, c1c2c3, L*a*b*, conversion from L*a*b*; Add slope direction in edge map detection, and input channel used for detection; Cleanup function to ensure pixel values are in [0,1]; Set all three channels to the value of one of them in each pixel; Get the neighbour of a pixel; Get an edge map made of the combination of the edge map on each channel, choosing the maximum slope amongs them for each pixel; Compare if an image is the same as another.
* ColorPatch. Set of CapyImgPixel. Get the average color; Get the bounding quadrilateral. Get the center of mass.
* ColorPatches. Set of CapyColorPatch.
* ColorChart. Add QP203 color chart L*a*b* data; Conversion ColorChart from RGB to L*a*b*; Split brightness in two versions for RGB and L*a*b*; Get similarity value between two charts; Automatically locate a chart in an image; Add X-Rite ColorChecker classic color chart.
* Index of min/max on arrays of basic types.
* ColorSpace. Enumeration to identify color spaces.
* FloodFill. Flood fill algorithm. Image segmentation.
* Triangle. Get area.
* Quadrilateral. Get area.
* MathFun. Get derivative; Get Jacobian.
* CapyVec. Refactor of CapyVector as a structure. Addition; Substraction; Multiplication; Cross product; Dot produt.
* CapyMat. Matrix data structure. Multiplication (with matrix and vector); Transpose; Inverse and pseudo inverse; Determinant; Copy; Set to identity.
* CapyIsAccessibleMem. Check if an adress is in the current accessible address space.
* Graph. Object to manipulate graphs. Add node; Add link; Get connectivity matrix; Get distance matrix (in number of link).
* CapyPowMod. Calculate (a^b)%c using the square and multiply algorithm
* Chrono. Class to measure elapsed time.
* Automatic code style checking and HTML/PDF doc generation.
* Dataset. Class to manipulate datasets saved as CSV file with a descriptive header containing each field, label, type (numerical/categorical) and interface (input/output).
* Bezier. Save/Load to binary stream; Export as ready-to-use C function.
* PointCloud. Class to manipulate point cloud. Load from PLY file (ascii format only); Approximate with a Bezier surface; Mean and covariance; Principal components.
* CapyColorCorrBezier. Color correction using Bezier surface; calculation of the Bezier surface matching to color chart; application of the Bezier surface to an image; load/save to a file.
* CapyColorCorr. Parent class color correction classes.
* CapyGreedy. Class implementing the Greedy algorithm.
* I/O Stream. Get file size.
* Math. QR decomposition; Eigen values and vectors.
* FileFormat. Virtual class for all the file format decoder/encoder implementations.
* PngFormat. Class to manipulate file in PNG format. Load/save an image.
* PlyFormat. Class to manipulate file in PLY format. Load/save a point cloud (ascii format).
* KMeans. Class implementing the k-means algorithm. Calculate the clusters best-fitting a point cloud (random, Forgy, plus plus); Get the cluster for a given point.
* DistributionDiscrete. Array of discrete events (pair of id/probability).
* Random. Get a random discrete event.
* FrequentistHypothesisTesting. Class implementing the frequentist hypothesis testing method.

Issues solved:

* &#35;9 The conversion of -0.3 to a CapyRatio fails.
* &#35;10 safeMalloc fails if the `size` argument is not a single item (ex: safeMalloc(a, 3 + n))

## v0.4

* MathFun. Add domains property to allow the user to specify the domain of each input.
* DiffEvo. Refactor to be multithreaded instead of multiprocessed; Refactor to take into account the domain of the fitness function; Add an optional constraint function.
* Dataset. Add cvtToMatForSingleCatPredictor, getValueAsNormalisedNum methods.
* CapyHyperplane. Class to manipulate hyperplane.
* Predictor. Parent class for all predictors. Evaluate the predictor (overall accuracy, confusion matrix).
* SupportVectorMachine. Support vector machine binary predictor. Train on a given dataset; Predict a given input.
* MemPool. Generic memory pool class. Alloc, free and flush elements of a given type.
* Math. 3D static vector; 3x3 static matrix; Conversion degrees/radians; Fast inverse square root; Solve quadratic/cubic/quartic equations; Fibonacci sequence, grid/polar lattice, sphere/demi-sphere lattice; Vector norm and normalisation; CapyMatCreateRotMat; CapyVec3DGetOrtho; PieceWiseGaussian; Approximated norm of a 2D vector.
* KfoldCrossValid. K-fold cross validation framework. Evaluate a CapyPredictor on a dataset.

Issues solved:

* &#35;11 The flag G_APPLICATION_FLAGS_NONE is deprecated and must be replaced with G_APPLICATION_DEFAULT_FLAGS when creating a GTK application.
* &#35;13 All unit tests should be refactored using Cutest.
* &#35;15 A silent mode for CapyArgParser should be added for cleaner unit tests.

## v0.5

* CapyPad. Macro to add fields with appropriately calculated size for explicit padding in structures.
* CapyAckley. Ackley's function implementation.
* CapyHimmelblau. Himmelblau's function implementation.
* CapyGradientDescent. Class implementing the gradient descent on a CapyMathFun object. Allow momentum and adaptive step.
* CapyBezierSpline. Composite of Bezier curves object.
* CapyCircle. 2D circle object. GetArea, getBezierSpline.
* CapyPen. DrawCircle, drawBezierSpline, drawGeometry2D. Refactor to use getBezierSpline on Triangle and Quadrilateral.
* CapyRandom. Replace xorshift64 with xorshift*64. Add PCG and set it as default algorithm instead of xorshift.
* CapyBezier. Replace CapyBezierCtrlIdx with uint16_t*.
* CapyGeometry2D. Parent class for CapyTriangle, CapyQuadrilateral, CapyCircle.
* CapyNeuralNetwork. Class implementing forward propagation neural network. Linear, step, sigmoid, hypertangent, relu, silu activation functions selectable per layer; multilayer; recurrent network supported.
* CapyDataset. Conversion to matrix for one hot encoding predictor.
* CapyNNPredictor. Multiclass predictor neural network. Training, prediction, export to C function, export to HTML.
* KfoldCrossValid. Load a predefined split.
* SlidingAverage. Class calculating a sliding average using O(1) memory.
* X11Display. Graphical display based on X11 and multithread.
* Polynomial1D. 1 dimension polynomial.
* DFT. Discrete Fourier Transform. Transform and inverse transform for 1 dimension polynomials of power-of-2 degree. Fourier series coefficients of a function for a given interval. Approximation of the function from the Fourier series coefficients.
* SupportVectorMachine. Export to HTML.
* DiffEvo. Add initialisation mode: random, or randomised seed. Add evolution mode: standard, or sequential with stride (instead of mutated values choosen randomly).
* Chrono. Get elapsed time with automatic selection of the most convenient unit.
* CapyMath. Test inclusion of a position in an ellipse. CapyCubicBezierEval; CapySmootherStep; CapyLerpNorm2Arr.
* CapyNoise. Parent class for all noise generator.
* CapyBNoise. Generate 2D noise using the B-Noise algorithm.

Issues solved:

* &#35;17 The function gettimeofday is obsolescent and should be replaced with clock_gettime in CapyChrono.
* &#35;18 Automatic padding may induce bug when using `union{T v[...];struct{T a,b,...};};`. Should add -Wpadded to compilation argument and resolve all these warnings.
* &#35;12 All XXXDestruct functions should be methods to deallocate memory correctly in the context of inheritance.
* &#35;21 CapyPen.drawBezier and CapyPen.drawBezierSpline crash if the curve/spline has a dimOut>2.
* &#35;

## v0.6

* CapyImg. Add saveToPath, CapyImgFromLoadFromPath.
* Cext. CapyChildProcEndsWithoutWait.
* CapyCombinator. Iterator on combination of indices.
* CapySampling. Parent class for all sampling algorithm.
* CapyPoissonSampling. Sampling according to the poisson distribution.
* CapyDFT2D. Discrete Fourier transform on images. Amplitude, phase, periodogram visualisation.
* CapyBresenham. Bresenham algorithm to iterate on 2D integer coordinates.
* CapyBezierIterator. Iterator allowing forEach(pos, ...) on CapyBezier of input dimension equal to 1.
* CapySdf. Signed distance function with constructive solid geometry.
* CapyQuaternion. Structure to manipulate 3D rotations using quaternions.

Issues solved:

* &#35;20 The following method and function should be added to the class CapyImg for convenience:
  CapyImg* CapyImgLoadFromPath)(char const* const path);
  void (*saveToPath)(char const* const path);
* &#35;23 array.h: the Shuffle method for unsized array clobbered data by calculating improperly their adress during swapping.
* &#35;19 missing unit tests for conversion of CapyDataset to CapyMat.
* &#35;25 The iterator of a CapyImg is not initialised when using CapyImgCreate, leading to a crash when using $(img, destruct)() because img.iter.destruct is not initialised.
* &#35;26 In CapyX11DisplayGetBuffer the wrong indice is used:
  CapyX11DisplayBuffer* buffer = that->buffers + that->outputBuffer;
should be
  CapyX11DisplayBuffer* buffer = that->buffers + that->inputBuffer;

## v0.7

* CapyPointCloud. Add links property to use the point cloud as a graph.
* CapyPathFinder. A* algorithm on CapyPointCloud.
* CapyColor. Oklab colorspace (conversion from/to XYZ).
* CapyX11Display. Add methods setPixel, fillRectangle, drawLine, drawCircle, clear, reset on X11DisplayBuffer. Add type CapyX11RGB.
* CapyMath. Add CapyVec2DSetAngle, CapyVec2DGetAngle, CapyVecGetCosineSimilarity, CapyMatAddMat, CapyMatProdScalar.
* CapyGeomety2D. Replace CapyTriangleCorner, CapyQuadrilateralCorner, CapyCircleCenter with CapyPoint2D. Add CapySegment, CapyRectangle.
* CapyCollisionDetection. Test collision between point/circle, point/rectangle, circle/circle, rectangle/rectangle.
* CapyRandom. Add CapyGetTrulyRandomValue.
* CapyHashFun. Parent class for hash function classes.
* CapyFNV1aHashFun. FNV1a hash function.
* CapyDict. Refactor as a hash table. Add remove entry method. Remove prev method on iterators.
* CapyMathFun. Add EvalDivergence.
* CapyGraph. Add PageRank.
* CapyImgKernel. Add sharpen kernel and edge detection kernel.

Issues solved:

* &#35;28 In geometricShape, CapyTriangleCorner, CapyQuadrilateralCorner, CapyCircleCenter should all be a same 2d point structure.
* &#35;

## v0.8

* CapyMath. Add CapyPowf, CapyVecGetMoment, CapyVecGetCovariance, CapyVecGetPearsonCorrelation, CapyVecGetDistanceCovariance, CapyVecGetDistanceCorrelation, CapyMatGetMomentCol.
* Generic trees and their iterator (breadth first, depth first).
* MemPool. Add size, nbUsed and sizeMax. Modif to let the user decide the name of the MemPool struct. Modif to allow the user to initialized the allocated memory.
* CapyMiniMax. Generic implementation of the minimax algorithm. Uses MemPool and sibling pruning.
* CapyRandom. Add Lemire's algorithm to generate faster integer within a range.
* CapyArray. Add shuffleLemire (shuffling using Fisher-Yate and Lemire), min and max given a comparator.
* CapyX11Display. Add drawBezier.
* containerOf. Macro to get the address of a structure instance from the address of one of its field.
* CapyChrono. Add getTimeStamp (get the current time in yyyymmddhhiiss format).
* CapyLSystem. Generic implementation of L-Systems. Lindenmayer algae L-System.
* CapyPointCloud. Add updateStdDev, updatePearsonCorrelation.
* CapyTurtleGraphic. Logo's turtle graphics implementation.
* CapyDataset. Add handling of null/unknown values when loading a dataset. Add datetime ("yyyy-mm-dd hh:ii" format). Add printData to print all or only a given number of lines of the data. Add getIdxFieldFromName, getNbFieldOfType, GetDistAsBinsGivenCatValue, GetDistAsBins, GetNbRowContainingVal, GetValuesFromTwoFieldsAsVectors.
* CapyFont. Class to convert text data into splines to be graphically rendered.
* CapyBezier. Add clone, translate, scale, rotate methods.
* CapyBezierSpline. Add clone, translate, scale, rotate methods.
* CapyPen. Add drawText, drawFilledRectangle, drawFilledCircle.
* CapyGraphPlotter. Class to render graphics from data.
* CapyImg. Add method pasteInto to paste an image into another, fillWithColor to fill the whole image with a given color. Add ConvertToBlackWhiteLightnessLine. Refactor the dimensions property to be able to access them as a CapyImgDims. Add method rotate.
* CapyGeoMap. Class to handle and manipulate geographic maps.
* CapyComparator. Add default comparator for string.
* CapyDate. Class to manipulate dates.
* Refactored CapyPredictor into CapyPredictor, and CapyNNPredictor into CapyNNPredictor. Both can now handle not only categorical output but numerical one too.
* CapyPredictor. Add input feature scaling (minMaxNormalization, minMaxNormalizationSym, meanNormalization, standardization).
* CapyNeuralNetwork. Add load/save.
* CapyNNPredictor. Add load/save.
* CapyTriangle. Add getBarycentricCoord.
* CapyGeometricShape. Add getPerimeter.

Issues solved:

* &#35;29 Compilation options should be hardened as described in https://best.openssf.org/Compiler-Hardening-Guides/Compiler-Options-Hardening-Guide-for-C-and-C++.html
* &#35;31 The index isn't updated in the iterator for dictionaries.
* &#35;32 The exportToJavascript and exportToC methods for NNActivationReLU is bugged. It should be 'x' instead of 'in[0]'

## v0.9

* CapyImg. Add isIntersectingAlpha. 
* CapyRange. Add clip. 
* CapyDataset. Add 'datetime hh:ii' category for fields. 
* CapyDate. Add print.
* CapyArray. Add binary search.
* CapyCompressor. Generic class for compression algorithms.
* CapyRLECompressor. RLE compression algorithm.
* CapyBurrowsWheelerTransform. Implementation of the Burrows-Wheeler transform.
* CapyBWTRLECompressor. BWT+RLE compression algorithm.
* CapyColorPalette. Object to create and manipulate palette of CapyColorData.
* CapyPixel2Cm and CapyCm2Pixel. Conversion functions between cm and pixels.
* CapyDataset. Add toPointCloud.
* CapyVec. Add VecSoftmax.
* CapyMathfun. Add EvalIntegral.
* CapyCamera. Class to compute 3D->2D projections.
* CapyLightRay. Class to modelise rays of light. Calculation of reflectivity, transmissivity and refraction angles.
* CapyPngFormat. Add support for 16 bits image (load only)
* CapyGaleShapleyPairing. Implementation of the Gale-Shapley pairing algorithm.
* CapyGraph. Add RemoveLinksFromNode, GetNodeById, GetLinkBetweenNodes.
* CapyList. Add Remove, Find.
* CapyMaze. Add CapyMaze2D to create 2D maze using the origin shift algorithm.
* CapyBTree. Generic implementation of B-Tree. Add, remove and find data.

Issues solved:

* &#35;33 The termination '\r' and/or '\n' of lines in dataset was incorrectly included in the value causing incorrect values for the last field.
* &#35;

## v0.10

* CapyPointCloudNearestNeighbour. Class to find the nearest point in a CapyPointCloud to a query point.
* CapyMath. Add CapyVecGetDistance, CapyVec2DRotate, CapyLcm, CapyGcdDecomposition, CapyMultMod, CapyGetFibonacciNumber, CapyVecLerp, CapyQuadraticAccel, CapyQuadraticDecel, CapyQuadraticAccelDecel, CapyQuadraticDecelAccel, CapyVecEasing, CapyVecQuickSelect, CapyVecGetMedian.
* CapyBTree. Refactor to let the user choose the max number of elements at creation time.
* CapyQuaternion. Add CapyQuaternionAllocRotFromVecToVec.
* CapyDiffEvo. Add verbose stream.
* CapyBitArray. Class to manipulate arrays of bits. Get and set bit individually; initialise from a uint8_t*.
* CapyList. Add insertSort.
* CapyX11Display. Add drawLineGradientColor, drawTriangle, drawTriangleGradientColor, drawFilledCircle, setAntialiasedPixel, toImg, Add CapyX11DisplayScreenShot.
* CapyRankedChoiceVoting.
* CapyCamera. Add projectInv, fromImgCoord.
* CapyMirrorBall. Class to render image from spherical mirror anamorphosis.
* CapyRungeKutta. Class implementing RK4.
* CapyColorPalette. Add GetColorInterpolated.
* CapyDist. Add GetSurprise.
* CapyDistDiscrete. Add GetEntropy.
* Add CapyDistDiscreteGetCrossEntropy, CapyDistDiscreteGetKLDivergence.
* Add CapyIsBigEndian.
* CapyGradientDescent. Add Adam method. Refactor the vector of step sizes into one single learning rate.
* CapyNNPredictor. Refactor to replace the adaptative learning rate with the gradient descent adam method.

Issues solved:

* &#35;37 The reset mechanism for CapyDiffEvo wasn't working as intended because the counter for iteration was incremented per agent instead of per epoch.
* &#35;38 The hypertangent and silu activation functions are erroneous
* &#35;39 The events source in X11Display are not registered
* &#35;40 CapyAckley is not the one described on Wikipedia
* &#35;

## v0.11

* CapyMarkovDecisionProcess. Finite discrete Markov decision process implementation. Get expected reward, get optimal policy, q-learning.
* CapyGeometry2DIntersection. getIntersectSegments, getIntersectCircles, getIntersectSegmentCircle.
* CapyLSystem. Hilbert curve. Heighway Dragon curve. Gosper curve.
* CapyPolicyGradient. Policy gradient method for learning optimal policy on Markov decision process with infinite state space and finite action space. Reinforce with baseline algorithm. Proximal policy optimisation algorithm. 
* CapyMath. CapyVecCopy.
* CapyRandom. getIdxGivenProbVec.
* CapyNeuralNetwork. Optional automatic softmax of output of evaluation.
* CapyRungeKutta. Refactor to support for input dimension >1 and order 2 derivative.
* RulerAndCompass. Class implementing Euclidean constructive geometry.
* CapyCircle. Add GetArcAsBezierSpline.
* CapyMath. Refactor CapyVec2DGetAngle to get two vectors as argument instead of using the x axis as constant second argument.

Issues solved:

* &#35;41 The mutex for exploration wasn't destroy in CapyMiniMax.destruct
* &#35;42 In standard and momentum gradient descent the parameters are updated in the same loop as the gradient, they must be updated in a separate loop after the gradient is calculated
* &#35;43 Bug in CapySolveQuadratic: missing 'else' makes result incorrect
* &#35;

## v0.12

* CapySpringMass. Simulation of spring-mass sytem with RK4 solver. Step, StepToStableState, GetStress
* CapyCatmullRom. Catmull-Rom splines.
* CapyCatmullRomIterator. Iterator on Catmull-Rom splines.
* CapyLinCombFun. Class to create linear combinations of CapyMathFun. Best fit of coefficients using linear regression.
* CapyTree. Add GetNbLeaf, Print (print a textual representation on a stream using ascii art and user defined function for leaves).
* CapyHierarchicalClustering. DIANA (standard and fast versions) clustering algorithm.
* CapyVerletIntegration. Class implementing verlet integration.
* CapyNNPredictor. Add choice of the loss function (mse, mae, huber, cross entropy)
* CapyMath. CapyFastExponential, CapyConvAcreSquareMeter, CapyConvSquareMeterAcre.
* CapyGeoMap. Add convertMeterToPixel, convertMeterToDegree.
* CapyDataset. Add getValAsUInt64Date. Add average and median value in field description.
* CapyDate. Add getDateAsCosSin, getTimeAsCosSin.
* CapyPredictor. Remove fitness and modify to support measuremetns: MAE, RMSE, R^2 and accuracy.

Issues solved:

* &#35;44 Allocation of the wrong memory size in CapyRungeKuttaCreate for temporary vectors used for calculation
* &#35;45 Modif the conversion to numeric value in the case of date and time to avoid discontinituities when plotting dataset containing dates over a large range
* &#35;46 Refactor all the CapyThatXXX with a macro methodOf(class)

## v0.13

* CapyCamera. Add screen type (perspective, orthographic), setToDimetric, setToIsometric.
* CapyMath. Add Flory decomposition.
* CapyDate. Add getDateAsNormalisedDouble, getTimeAsNormalisedDouble, setDateFromNormalisedDouble, setTimeFromNormalisedDouble.
* CapyLinCombFun. Add linearRegressionFromMat.
* CapyRulerAndCompass. Add 'spline' property to access the last drawn geometry as a CapyBezierSpline.
* CapyGradientDescent. Add minibatch.

Issues solved:

* &#35;47 In nnPredictor.LossFun, the temporary vector to store the result of evaluation should be made a class property to avoid having to allocate it at each call of Eval or EvalDerivative.
* &#35;48 In nnPredictor, the derivative of the loss function for cross entropy is wrong, it should be `softmax(out)-target` instead of `out-target`.
* &#35;
